/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.ClusterSelector;
import org.axonframework.eventhandling.DefaultClusterSelector;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventBusTerminal;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.EventListenerSubscriptionFailedException;

public class ClusteringEventBus
implements EventBus {
    private final EventBusTerminal terminal;
    private final ClusterSelector clusterSelector;
    private final Set<Cluster> clusters = new HashSet<Cluster>();

    public ClusteringEventBus() {
        this(new DefaultClusterSelector(), new SimpleEventBusTerminal());
    }

    public ClusteringEventBus(EventBusTerminal terminal) {
        this(new DefaultClusterSelector(), terminal);
    }

    public ClusteringEventBus(ClusterSelector clusterSelector) {
        this(clusterSelector, new SimpleEventBusTerminal());
    }

    public ClusteringEventBus(ClusterSelector clusterSelector, EventBusTerminal terminal) {
        Assert.notNull(clusterSelector, "clusterSelector may not be null");
        Assert.notNull(terminal, "terminal may not be null");
        this.clusterSelector = clusterSelector;
        this.terminal = terminal;
    }

    @Override
    public void publish(EventMessage ... events) {
        this.terminal.publish(events);
    }

    @Override
    public void subscribe(EventListener eventListener) {
        this.clusterFor(eventListener).subscribe(eventListener);
    }

    @Override
    public void unsubscribe(EventListener eventListener) {
        this.clusterFor(eventListener).unsubscribe(eventListener);
    }

    private synchronized Cluster clusterFor(EventListener eventListener) {
        Cluster cluster = this.clusterSelector.selectCluster(eventListener);
        if (cluster == null) {
            Class<?> listenerType = eventListener.getClass();
            if (eventListener instanceof EventListenerProxy) {
                listenerType = ((EventListenerProxy)eventListener).getTargetType();
            }
            throw new EventListenerSubscriptionFailedException(String.format("Unable to subscribe [%s] to the Event Bus. There is no suitable cluster for it. Make sure the ClusterSelector is configured properly", listenerType.getName()));
        }
        if (this.clusters.add(cluster)) {
            this.terminal.onClusterCreated(cluster);
        }
        return cluster;
    }

    private static class SimpleEventBusTerminal
    implements EventBusTerminal {
        private final List<Cluster> clusters = new CopyOnWriteArrayList<Cluster>();

        private SimpleEventBusTerminal() {
        }

        @Override
        public void publish(EventMessage ... events) {
            for (Cluster cluster : this.clusters) {
                cluster.publish(events);
            }
        }

        @Override
        public void onClusterCreated(Cluster cluster) {
            this.clusters.add(cluster);
        }
    }
}

