/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.ClusterSelector;
import org.axonframework.eventhandling.DefaultClusterSelector;
import org.axonframework.eventhandling.EventListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

public class AutowiringClusterSelector
implements ClusterSelector,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final List<ClusterSelector> selectors = new ArrayList<ClusterSelector>();
    private volatile boolean initialized;

    @Override
    public Cluster selectCluster(EventListener eventListener) {
        if (!this.initialized) {
            this.initialize();
        }
        Cluster cluster = null;
        Iterator<ClusterSelector> selectorIterator = this.selectors.iterator();
        while (cluster == null && selectorIterator.hasNext()) {
            cluster = selectorIterator.next().selectCluster(eventListener);
        }
        return cluster;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Map candidates = this.applicationContext.getBeansOfType(ClusterSelector.class);
        TreeSet<OrderedClusterSelector> orderedCandidates = new TreeSet<OrderedClusterSelector>();
        for (Map.Entry entry : candidates.entrySet()) {
            if (entry.getValue() == this) continue;
            orderedCandidates.add(new OrderedClusterSelector((String)entry.getKey(), (ClusterSelector)entry.getValue()));
        }
        for (OrderedClusterSelector candidate : orderedCandidates) {
            this.selectors.add(candidate.selector);
        }
        if (this.selectors.isEmpty()) {
            this.selectors.add(new DefaultClusterSelector());
        }
    }

    private static final class OrderedClusterSelector
    implements Comparable<OrderedClusterSelector> {
        private final String name;
        private final ClusterSelector selector;
        private final int order;

        private OrderedClusterSelector(String name, ClusterSelector selector) {
            this.name = name;
            this.selector = selector;
            this.order = selector instanceof Ordered ? ((Ordered)selector).getOrder() : (selector.getClass().isAnnotationPresent(Order.class) ? selector.getClass().getAnnotation(Order.class).value() : 0);
        }

        @Override
        public int compareTo(OrderedClusterSelector o) {
            if (this.order == o.order) {
                return this.name.compareTo(o.name);
            }
            return this.order < o.order ? -1 : 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderedClusterSelector that = (OrderedClusterSelector)o;
            return this.order == that.order && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.order;
            return result;
        }
    }
}

