/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.ClusterMetaData;
import org.axonframework.eventhandling.DefaultClusterMetaData;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventProcessingMonitor;
import org.axonframework.eventhandling.EventProcessingMonitorCollection;
import org.axonframework.eventhandling.EventProcessingMonitorSupport;
import org.axonframework.eventhandling.MultiplexingEventProcessingMonitor;

public abstract class AbstractCluster
implements Cluster {
    private final String name;
    private final Set<EventListener> eventListeners;
    private final Set<EventListener> immutableEventListeners;
    private final ClusterMetaData clusterMetaData = new DefaultClusterMetaData();
    private final EventProcessingMonitorCollection subscribedMonitors = new EventProcessingMonitorCollection();
    private final MultiplexingEventProcessingMonitor eventProcessingMonitor = new MultiplexingEventProcessingMonitor(this.subscribedMonitors);

    protected AbstractCluster(String name) {
        Assert.notNull(name, "name may not be null");
        this.name = name;
        this.eventListeners = new CopyOnWriteArraySet<EventListener>();
        this.immutableEventListeners = Collections.unmodifiableSet(this.eventListeners);
    }

    protected AbstractCluster(String name, Comparator<EventListener> comparator) {
        Assert.notNull(name, "name may not be null");
        this.name = name;
        this.eventListeners = new ConcurrentSkipListSet<EventListener>(comparator);
        this.immutableEventListeners = Collections.unmodifiableSet(this.eventListeners);
    }

    @Override
    public void publish(EventMessage ... events) {
        this.doPublish(Arrays.asList(events), this.eventListeners, this.eventProcessingMonitor);
    }

    protected abstract void doPublish(List<EventMessage> var1, Set<EventListener> var2, MultiplexingEventProcessingMonitor var3);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void subscribe(EventListener eventListener) {
        this.eventListeners.add(eventListener);
        if (eventListener instanceof EventProcessingMonitorSupport) {
            ((EventProcessingMonitorSupport)((Object)eventListener)).subscribeEventProcessingMonitor(this.eventProcessingMonitor);
        }
    }

    @Override
    public void unsubscribe(EventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public ClusterMetaData getMetaData() {
        return this.clusterMetaData;
    }

    @Override
    public Set<EventListener> getMembers() {
        return this.immutableEventListeners;
    }

    @Override
    public void subscribeEventProcessingMonitor(EventProcessingMonitor monitor) {
        this.subscribedMonitors.subscribeEventProcessingMonitor(monitor);
    }

    @Override
    public void unsubscribeEventProcessingMonitor(EventProcessingMonitor monitor) {
        this.subscribedMonitors.unsubscribeEventProcessingMonitor(monitor);
    }
}

