/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;

public class SimpleDomainEventStream
implements DomainEventStream {
    private static final DomainEventStream EMPTY_STREAM = new SimpleDomainEventStream(new DomainEventMessage[0]);
    private int nextIndex;
    private final DomainEventMessage[] events;

    public SimpleDomainEventStream(Collection<? extends DomainEventMessage> events) {
        this(events.toArray(new DomainEventMessage[events.size()]));
    }

    public SimpleDomainEventStream(DomainEventMessage ... events) {
        this.events = Arrays.copyOfRange(events, 0, events.length);
    }

    @Override
    public boolean hasNext() {
        return this.events.length > this.nextIndex;
    }

    @Override
    public DomainEventMessage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Trying to peek beyond the limits of this stream.");
        }
        return this.events[this.nextIndex++];
    }

    @Override
    public DomainEventMessage peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Trying to peek beyond the limits of this stream.");
        }
        return this.events[this.nextIndex];
    }

    public static DomainEventStream emptyStream() {
        return EMPTY_STREAM;
    }
}

