/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.axonframework.common.Assert;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.EventRegistrationCallback;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.domain.SimpleDomainEventStream;

public class EventContainer
implements Serializable {
    private static final long serialVersionUID = -39816393359395878L;
    private final List<DomainEventMessage> events = new ArrayList<DomainEventMessage>();
    private final Object aggregateIdentifier;
    private Long lastCommittedSequenceNumber;
    private transient Long lastSequenceNumber;
    private transient List<EventRegistrationCallback> registrationCallbacks;

    public EventContainer(Object aggregateIdentifier) {
        this.aggregateIdentifier = aggregateIdentifier;
    }

    public <T> DomainEventMessage<T> addEvent(MetaData metaData, T payload) {
        return this.addEvent(new GenericDomainEventMessage<T>(this.aggregateIdentifier, this.newSequenceNumber(), payload, metaData));
    }

    public <T> DomainEventMessage<T> addEvent(DomainEventMessage<T> domainEventMessage) {
        if (domainEventMessage.getAggregateIdentifier() == null) {
            domainEventMessage = new GenericDomainEventMessage(domainEventMessage.getIdentifier(), domainEventMessage.getTimestamp(), this.aggregateIdentifier, domainEventMessage.getSequenceNumber(), domainEventMessage.getPayload(), domainEventMessage.getMetaData());
        }
        if (this.registrationCallbacks != null) {
            for (EventRegistrationCallback callback : this.registrationCallbacks) {
                domainEventMessage = callback.onRegisteredEvent(domainEventMessage);
            }
        }
        this.lastSequenceNumber = domainEventMessage.getSequenceNumber();
        this.events.add(domainEventMessage);
        return domainEventMessage;
    }

    public DomainEventStream getEventStream() {
        return new SimpleDomainEventStream(this.events);
    }

    public Object getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public void initializeSequenceNumber(Long lastKnownSequenceNumber) {
        Assert.state(this.events.size() == 0, "Cannot set first sequence number if events have already been added");
        this.lastCommittedSequenceNumber = lastKnownSequenceNumber;
    }

    public Long getLastSequenceNumber() {
        if (this.events.isEmpty()) {
            return this.lastCommittedSequenceNumber;
        }
        if (this.lastSequenceNumber == null) {
            this.lastSequenceNumber = this.events.get(this.events.size() - 1).getSequenceNumber();
        }
        return this.lastSequenceNumber;
    }

    public Long getLastCommittedSequenceNumber() {
        return this.lastCommittedSequenceNumber;
    }

    public void commit() {
        this.lastCommittedSequenceNumber = this.getLastSequenceNumber();
        this.events.clear();
        if (this.registrationCallbacks != null) {
            this.registrationCallbacks.clear();
        }
    }

    public int size() {
        return this.events.size();
    }

    private long newSequenceNumber() {
        Long currentSequenceNumber = this.getLastSequenceNumber();
        if (currentSequenceNumber == null) {
            return 0L;
        }
        return currentSequenceNumber + 1L;
    }

    public List<DomainEventMessage> getEventList() {
        return Collections.unmodifiableList(this.events);
    }

    public void addEventRegistrationCallback(EventRegistrationCallback eventRegistrationCallback) {
        if (this.registrationCallbacks == null) {
            this.registrationCallbacks = new ArrayList<EventRegistrationCallback>();
        }
        this.registrationCallbacks.add(eventRegistrationCallback);
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.set(i, eventRegistrationCallback.onRegisteredEvent(this.events.get(i)));
        }
    }
}

