/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.domain;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.axonframework.domain.AggregateIdentifierNotInitializedException;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.EventContainer;
import org.axonframework.domain.EventRegistrationCallback;
import org.axonframework.domain.MetaData;
import org.axonframework.domain.SimpleDomainEventStream;

@MappedSuperclass
public abstract class AbstractAggregateRoot<I>
implements AggregateRoot<I>,
Serializable {
    private static final long serialVersionUID = 6330592271927197888L;
    @Transient
    private volatile EventContainer eventContainer;
    @Transient
    private boolean deleted = false;
    @Basic(optional=true)
    private Long lastEventSequenceNumber;
    @Version
    private Long version;

    protected <T> DomainEventMessage<T> registerEvent(T payload) {
        return this.registerEvent(MetaData.emptyInstance(), payload);
    }

    protected <T> DomainEventMessage<T> registerEvent(MetaData metaData, T payload) {
        return this.getEventContainer().addEvent(metaData, payload);
    }

    protected <T> DomainEventMessage<T> registerEventMessage(DomainEventMessage<T> message) {
        return this.getEventContainer().addEvent(message);
    }

    protected void markDeleted() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void addEventRegistrationCallback(EventRegistrationCallback eventRegistrationCallback) {
        this.getEventContainer().addEventRegistrationCallback(eventRegistrationCallback);
    }

    @Override
    public DomainEventStream getUncommittedEvents() {
        if (this.eventContainer == null) {
            return SimpleDomainEventStream.emptyStream();
        }
        return this.eventContainer.getEventStream();
    }

    @Override
    public void commitEvents() {
        if (this.eventContainer != null) {
            this.lastEventSequenceNumber = this.eventContainer.getLastSequenceNumber();
            this.eventContainer.commit();
        }
    }

    @Override
    public int getUncommittedEventCount() {
        return this.eventContainer != null ? this.eventContainer.size() : 0;
    }

    protected void initializeEventStream(long lastSequenceNumber) {
        this.getEventContainer().initializeSequenceNumber(lastSequenceNumber);
        this.lastEventSequenceNumber = lastSequenceNumber >= 0L ? Long.valueOf(lastSequenceNumber) : null;
    }

    protected Long getLastCommittedEventSequenceNumber() {
        if (this.eventContainer == null) {
            return this.lastEventSequenceNumber;
        }
        return this.eventContainer.getLastCommittedSequenceNumber();
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    private EventContainer getEventContainer() {
        if (this.eventContainer == null) {
            Object identifier = this.getIdentifier();
            if (identifier == null) {
                throw new AggregateIdentifierNotInitializedException("AggregateIdentifier is unknown in [" + this.getClass().getName() + "]. " + "Make sure the Aggregate Identifier is initialized before registering events.");
            }
            this.eventContainer = new EventContainer(identifier);
            this.eventContainer.initializeSequenceNumber(this.lastEventSequenceNumber);
        }
        return this.eventContainer;
    }
}

