/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.Serializer;
import org.axonframework.upcasting.LazyUpcasterChain;
import org.axonframework.upcasting.SimpleUpcasterChain;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class UpcasterChainBeanDefinitionParser {
    private static final String CONVERTER_FACTORY_ATTRIBUTE = "converter-factory";
    private static final String SERIALIZER_ATTRIBUTE = "serializer";
    private static final String STRATEGY_ATTRIBUTE = "strategy";
    private static final String STRATEGY_EAGER = "eager";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.parse(element, parserContext, AutowiredBean.createAutowiredBeanWithFallback(new ChainingConverterFactory(), ConverterFactory.class, Serializer.class));
    }

    public BeanDefinition parse(Element element, ParserContext parserContext, Object defaultSerializer) {
        String strategy = element.getAttribute(STRATEGY_ATTRIBUTE);
        Class chainType = LazyUpcasterChain.class;
        if (STRATEGY_EAGER.equals(strategy)) {
            chainType = SimpleUpcasterChain.class;
        }
        AbstractBeanDefinition bd = BeanDefinitionBuilder.genericBeanDefinition(chainType).getBeanDefinition();
        bd.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)parserContext.getDelegate().parseListElement(element, (BeanDefinition)bd));
        if (element.hasAttribute(CONVERTER_FACTORY_ATTRIBUTE)) {
            bd.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(element.getAttribute(CONVERTER_FACTORY_ATTRIBUTE)));
        } else if (element.hasAttribute(SERIALIZER_ATTRIBUTE)) {
            bd.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(element.getAttribute(SERIALIZER_ATTRIBUTE)));
        } else {
            bd.getConstructorArgumentValues().addIndexedArgumentValue(0, defaultSerializer);
        }
        return bd;
    }
}

