/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.axonframework.contextsupport.spring.AsyncSagaManagerBeanDefinitionParser;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.SyncSagaManagerBeanDefinitionParser;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.saga.SagaManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SagaManagerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String EVENT_BUS_ATTRIBUTE = "event-bus";
    private final AsyncSagaManagerBeanDefinitionParser async;
    private final SyncSagaManagerBeanDefinitionParser sync;
    private final Map<BeanDefinition, String> eventBusPerSagaManager = Collections.synchronizedMap(new WeakHashMap());

    SagaManagerBeanDefinitionParser() {
        this.async = new AsyncSagaManagerBeanDefinitionParser();
        this.sync = new SyncSagaManagerBeanDefinitionParser();
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        AbstractBeanDefinition definition = DomUtils.getChildElementByTagName((Element)element, (String)"async") != null ? this.async.parseInternal(element, parserContext) : this.sync.parseInternal(element, parserContext);
        if (element.hasAttribute(EVENT_BUS_ATTRIBUTE)) {
            String eventBus = element.getAttribute(EVENT_BUS_ATTRIBUTE);
            this.eventBusPerSagaManager.put((BeanDefinition)definition, eventBus);
        }
        return definition;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        super.registerBeanDefinition(definition, registry);
        String eventBus = this.eventBusPerSagaManager.remove(definition.getBeanDefinition());
        registry.registerBeanDefinition(definition.getBeanName() + "_LifecycleManager", this.buildLifecycleManager(definition.getBeanName(), eventBus));
    }

    private BeanDefinition buildLifecycleManager(String sagaManager, String eventBus) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SagaManagerLifecycleManager.class);
        if (eventBus != null) {
            builder.addPropertyReference("eventBus", eventBus);
        } else {
            builder = builder.addPropertyValue("eventBus", (Object)AutowiredBean.createAutowiredBean(EventBus.class));
        }
        return builder.addPropertyReference("sagaManager", sagaManager).getBeanDefinition();
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    public static class SagaManagerLifecycleManager
    implements SmartLifecycle {
        private volatile EventBus eventBus;
        private volatile SagaManager sagaManager;
        private volatile boolean started = false;

        public void start() {
            this.eventBus.subscribe(this.sagaManager);
            this.started = true;
        }

        public void stop() {
            this.eventBus.unsubscribe(this.sagaManager);
            this.started = false;
        }

        public boolean isRunning() {
            return this.started;
        }

        public void setEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
        }

        public void setSagaManager(SagaManager sagaManager) {
            this.sagaManager = sagaManager;
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(Runnable callback) {
            this.stop();
            callback.run();
        }

        public int getPhase() {
            return 0;
        }
    }
}

