/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import org.axonframework.common.jpa.ContainerManagedEntityManagerProvider;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.UpcasterChainBeanDefinitionParser;
import org.axonframework.eventstore.jpa.DefaultEventEntryStore;
import org.axonframework.eventstore.jpa.JpaEventStore;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.xml.XStreamSerializer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JpaEventStoreBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String FORCE_UTC_TIMESTAMP_ATTRIBUTE = "force-utc-timestamp";
    private final UpcasterChainBeanDefinitionParser upcasterChainParser = new UpcasterChainBeanDefinitionParser();
    private static final String EVENT_SERIALIZER_ATTRIBUTE = "event-serializer";
    private static final String DATA_SOURCE_ATTRIBUTE = "data-source";
    private static final String PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE = "persistence-exception-resolver";
    private static final String MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE = "max-snapshots-archived";
    private static final String BATCH_SIZE_ATTRIBUTE = "batch-size";
    private static final String ENTITY_MANAGER_PROVIDER = "entity-manager-provider";
    private static final String UPCASTERS_ELEMENT = "upcasters";
    private static final String EVENT_ENTRY_STORE_ATTRIBUTE = "event-entry-store-ref";
    private static final String EVENT_ENTRY_FACTORY_ATTRIBUTE = "event-entry-factory-ref";

    protected Class<?> getBeanClass(Element element) {
        return JpaEventStore.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element upcasters;
        if (element.hasAttribute(ENTITY_MANAGER_PROVIDER)) {
            builder.addConstructorArgReference(element.getAttribute(ENTITY_MANAGER_PROVIDER));
        } else {
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(ContainerManagedEntityManagerProvider.class).getBeanDefinition());
        }
        Object serializer = element.hasAttribute(EVENT_SERIALIZER_ATTRIBUTE) ? new RuntimeBeanReference(element.getAttribute(EVENT_SERIALIZER_ATTRIBUTE)) : AutowiredBean.createAutowiredBeanWithFallback(new XStreamSerializer(), Serializer.class);
        builder.addConstructorArgValue(serializer);
        if (element.hasAttribute(EVENT_ENTRY_STORE_ATTRIBUTE)) {
            RuntimeBeanReference eventEntryStore = new RuntimeBeanReference(element.getAttribute(EVENT_ENTRY_STORE_ATTRIBUTE));
            builder.addConstructorArgValue((Object)eventEntryStore);
            this.assertNoCombinationOf(element, parserContext, EVENT_ENTRY_FACTORY_ATTRIBUTE, EVENT_ENTRY_STORE_ATTRIBUTE);
            this.assertNoCombinationOf(element, parserContext, FORCE_UTC_TIMESTAMP_ATTRIBUTE, EVENT_ENTRY_STORE_ATTRIBUTE);
        } else if (element.hasAttribute(EVENT_ENTRY_FACTORY_ATTRIBUTE)) {
            String eventEntryFactory = element.getAttribute(EVENT_ENTRY_FACTORY_ATTRIBUTE);
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultEventEntryStore.class).addConstructorArgReference(eventEntryFactory).getBeanDefinition());
            this.assertNoCombinationOf(element, parserContext, FORCE_UTC_TIMESTAMP_ATTRIBUTE, EVENT_ENTRY_FACTORY_ATTRIBUTE);
        } else if (element.hasAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE)) {
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultEventEntryStore.class).addConstructorArgValue((Object)element.getAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE)).getBeanDefinition());
        }
        if (element.hasAttribute(DATA_SOURCE_ATTRIBUTE)) {
            builder.addPropertyReference("dataSource", element.getAttribute(DATA_SOURCE_ATTRIBUTE));
        }
        if (element.hasAttribute(PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE)) {
            builder.addPropertyReference("persistenceExceptionResolver", element.getAttribute(PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE));
        }
        if (element.hasAttribute(MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE)) {
            builder.addPropertyValue("maxSnapshotsArchived", (Object)element.getAttribute(MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE));
        }
        if (element.hasAttribute(BATCH_SIZE_ATTRIBUTE)) {
            builder.addPropertyValue("batchSize", (Object)element.getAttribute(BATCH_SIZE_ATTRIBUTE));
        }
        if ((upcasters = DomUtils.getChildElementByTagName((Element)element, (String)UPCASTERS_ELEMENT)) != null) {
            builder.addPropertyValue("upcasterChain", (Object)this.upcasterChainParser.parse(upcasters, parserContext, serializer));
        }
    }

    private void assertNoCombinationOf(Element element, ParserContext parserContext, String overriddenAttribute, String overridingAttribute) {
        if (element.hasAttribute(overridingAttribute) && element.hasAttribute(overriddenAttribute)) {
            parserContext.getReaderContext().warning("On a jpa-event-store, the attributes " + overriddenAttribute + " and " + overridingAttribute + " should not both be defined. The " + overriddenAttribute + " attribute is ignored.", (Object)element);
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

