/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import javax.sql.DataSource;
import org.axonframework.common.jdbc.SpringDataSourceConnectionProvider;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.UpcasterChainBeanDefinitionParser;
import org.axonframework.eventstore.jdbc.DefaultEventEntryStore;
import org.axonframework.eventstore.jdbc.GenericEventSqlSchema;
import org.axonframework.eventstore.jdbc.JdbcEventStore;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.xml.XStreamSerializer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JdbcEventStoreBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final UpcasterChainBeanDefinitionParser upcasterChainParser = new UpcasterChainBeanDefinitionParser();
    private static final String FORCE_UTC_TIMESTAMP_ATTRIBUTE = "force-utc-timestamp";
    private static final String EVENT_SERIALIZER_ATTRIBUTE = "event-serializer";
    private static final String DATA_SOURCE_ATTRIBUTE = "data-source";
    private static final String PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE = "persistence-exception-resolver";
    private static final String MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE = "max-snapshots-archived";
    private static final String BATCH_SIZE_ATTRIBUTE = "batch-size";
    private static final String CONNECTION_PROVIDER = "connection-provider";
    private static final String SQL_SCHEMA = "sql-schema";
    private static final String UPCASTERS_ELEMENT = "upcasters";
    private static final String EVENT_ENTRY_STORE_ATTRIBUTE = "event-entry-store-ref";

    protected Class<?> getBeanClass(Element element) {
        return JdbcEventStore.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element upcasters;
        BeanDefinitionBuilder eventEntryStore;
        if (element.hasAttribute(EVENT_ENTRY_STORE_ATTRIBUTE)) {
            eventEntryStore = new RuntimeBeanReference(element.getAttribute(EVENT_ENTRY_STORE_ATTRIBUTE));
            builder.addConstructorArgValue((Object)eventEntryStore);
            if (element.hasAttribute(SQL_SCHEMA)) {
                parserContext.getReaderContext().warning("Attribute 'sql-schema' is ignored, as an 'event-entry-store-ref' is already provided.", (Object)element);
            }
            if (element.hasAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE)) {
                parserContext.getReaderContext().warning("Attribute 'force-utc-timestamp' is ignored, as an 'event-entry-store-ref' is already provided.", (Object)element);
            }
        } else {
            eventEntryStore = BeanDefinitionBuilder.genericBeanDefinition(DefaultEventEntryStore.class);
            if (element.hasAttribute(CONNECTION_PROVIDER)) {
                eventEntryStore.addConstructorArgReference(element.getAttribute(CONNECTION_PROVIDER));
            } else {
                BeanDefinitionBuilder dataSourceConnectionProvider = BeanDefinitionBuilder.genericBeanDefinition(SpringDataSourceConnectionProvider.class);
                if (element.hasAttribute(DATA_SOURCE_ATTRIBUTE)) {
                    dataSourceConnectionProvider.addConstructorArgReference(element.getAttribute(DATA_SOURCE_ATTRIBUTE));
                } else {
                    dataSourceConnectionProvider.addConstructorArgValue((Object)AutowiredBean.createAutowiredBean(DataSource.class));
                }
                eventEntryStore.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(UnitOfWorkAwareConnectionProviderWrapper.class).addConstructorArgValue((Object)dataSourceConnectionProvider.getBeanDefinition()).getBeanDefinition());
            }
            if (element.hasAttribute(SQL_SCHEMA)) {
                eventEntryStore.addConstructorArgReference(element.getAttribute(SQL_SCHEMA));
                if (element.hasAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE)) {
                    parserContext.getReaderContext().warning("Attribute 'force-utc-timestamp' is ignored, as an 'sql-schema' is already provided.", (Object)element.getAttributeNode(FORCE_UTC_TIMESTAMP_ATTRIBUTE));
                }
            } else {
                BeanDefinitionBuilder schemaDefinition = BeanDefinitionBuilder.genericBeanDefinition(GenericEventSqlSchema.class);
                if (element.hasAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE)) {
                    schemaDefinition.addPropertyValue("forceUtc", (Object)element.getAttribute(FORCE_UTC_TIMESTAMP_ATTRIBUTE));
                }
                eventEntryStore.addConstructorArgValue((Object)schemaDefinition.getBeanDefinition());
            }
            builder.addConstructorArgValue((Object)eventEntryStore.getBeanDefinition());
        }
        Object serializer = element.hasAttribute(EVENT_SERIALIZER_ATTRIBUTE) ? new RuntimeBeanReference(element.getAttribute(EVENT_SERIALIZER_ATTRIBUTE)) : AutowiredBean.createAutowiredBeanWithFallback(new XStreamSerializer(), Serializer.class);
        builder.addConstructorArgValue(serializer);
        if (element.hasAttribute(PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE)) {
            builder.addPropertyReference("persistenceExceptionResolver", element.getAttribute(PERSISTENCE_EXCEPTION_RESOLVER_ATTRIBUTE));
        }
        if (element.hasAttribute(MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE)) {
            builder.addPropertyValue("maxSnapshotsArchived", (Object)element.getAttribute(MAX_SNAPSHOTS_ARCHIVED_ATTRIBUTE));
        }
        if (element.hasAttribute(BATCH_SIZE_ATTRIBUTE)) {
            builder.addPropertyValue("batchSize", (Object)element.getAttribute(BATCH_SIZE_ATTRIBUTE));
        }
        if ((upcasters = DomUtils.getChildElementByTagName((Element)element, (String)UPCASTERS_ELEMENT)) != null) {
            builder.addPropertyValue("upcasterChain", (Object)this.upcasterChainParser.parse(upcasters, parserContext, serializer));
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

