/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.cache.WeakReferenceCache;
import org.axonframework.commandhandling.disruptor.DisruptorCommandBus;
import org.axonframework.common.Assert;
import org.axonframework.contextsupport.spring.AutowiredBean;
import org.axonframework.contextsupport.spring.SnapshotterTriggerBeanDefinitionParser;
import org.axonframework.contextsupport.spring.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.CompositeEventStreamDecorator;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventStreamDecorator;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.SnapshotterTrigger;
import org.axonframework.repository.Repository;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DisruptorRepositoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String ATTRIBUTE_AGGREGATE_FACTORY = "aggregate-factory";
    private static final String ATTRIBUTE_AGGREGATE_TYPE = "aggregate-type";
    private static final String EVENT_PROCESSORS_ELEMENT = "event-processors";
    private static final String SNAPSHOT_TRIGGER_ELEMENT = "snapshotter-trigger";
    private static final String EVENT_STREAM_DECORATORS_PROPERTY = "eventStreamDecorators";
    private static final String SNAPSHOTTER_TRIGGER_PROPERTY = "snapshotterTrigger";
    private final SnapshotterTriggerBeanDefinitionParser snapshotterTriggerParser = new SnapshotterTriggerBeanDefinitionParser();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String commandBusId = null;
        if (element.hasAttribute("command-bus")) {
            commandBusId = element.getAttribute("command-bus");
        }
        PropertyValue aggregateCache = null;
        if (element.hasAttribute("cache")) {
            aggregateCache = new PropertyValue("cache", (Object)new RuntimeBeanReference(element.getAttribute("cache")));
        }
        return this.createRepositoryDefinition(element, commandBusId, parserContext, aggregateCache);
    }

    public AbstractBeanDefinition createRepositoryDefinition(Element repositoryElement, String commandBusId, ParserContext parserContext, PropertyValue aggregateCache) {
        List processorsList;
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(RepositoryFactoryBean.class);
        definitionBuilder = commandBusId == null ? definitionBuilder.addPropertyValue("commandBus", (Object)AutowiredBean.createAutowiredBean(DisruptorCommandBus.class)) : definitionBuilder.addPropertyReference("commandBus", commandBusId);
        if (repositoryElement.hasAttribute(ATTRIBUTE_AGGREGATE_FACTORY)) {
            definitionBuilder = definitionBuilder.addPropertyReference("aggregateFactory", repositoryElement.getAttribute(ATTRIBUTE_AGGREGATE_FACTORY));
        } else {
            String aggregateType = repositoryElement.getAttribute(ATTRIBUTE_AGGREGATE_TYPE);
            Assert.notEmpty(aggregateType, "Either one of 'aggregate-type' or 'aggregate-factory' attributes must be set on repository elements in <disruptor-command-bus>");
            definitionBuilder = definitionBuilder.addPropertyValue("aggregateFactory", (Object)BeanDefinitionBuilder.genericBeanDefinition(GenericAggregateFactory.class).addConstructorArgValue((Object)aggregateType).addConstructorArgValue((Object)SpringContextParameterResolverFactoryBuilder.getBeanReference(parserContext.getRegistry())).getBeanDefinition());
        }
        Element processorsElement = DomUtils.getChildElementByTagName((Element)repositoryElement, (String)EVENT_PROCESSORS_ELEMENT);
        Element snapshotTriggerElement = DomUtils.getChildElementByTagName((Element)repositoryElement, (String)SNAPSHOT_TRIGGER_ELEMENT);
        if (snapshotTriggerElement != null) {
            BeanDefinition triggerDefinition = this.snapshotterTriggerParser.parse(snapshotTriggerElement, parserContext);
            if (aggregateCache != null && aggregateCache.getValue() != null) {
                triggerDefinition.getPropertyValues().add("aggregateCache", aggregateCache.getValue());
            } else {
                triggerDefinition.getPropertyValues().add("aggregateCache", (Object)BeanDefinitionBuilder.genericBeanDefinition(WeakReferenceCache.class).getBeanDefinition());
            }
            definitionBuilder = definitionBuilder.addPropertyValue(SNAPSHOTTER_TRIGGER_PROPERTY, (Object)triggerDefinition);
        }
        AbstractBeanDefinition definition = definitionBuilder.getBeanDefinition();
        if (processorsElement != null && !(processorsList = parserContext.getDelegate().parseListElement(processorsElement, (BeanDefinition)definition)).isEmpty()) {
            definition.getPropertyValues().add(EVENT_STREAM_DECORATORS_PROPERTY, (Object)processorsList);
        }
        return definition;
    }

    public static class RepositoryFactoryBean
    implements FactoryBean<Repository> {
        private DisruptorCommandBus commandBus;
        private List<EventStreamDecorator> eventStreamDecorators = new ArrayList<EventStreamDecorator>();
        private AggregateFactory<? extends EventSourcedAggregateRoot> factory;

        public Repository getObject() throws Exception {
            if (this.eventStreamDecorators.isEmpty()) {
                return this.commandBus.createRepository(this.factory);
            }
            return this.commandBus.createRepository(this.factory, new CompositeEventStreamDecorator(this.eventStreamDecorators));
        }

        public Class<?> getObjectType() {
            return Repository.class;
        }

        public boolean isSingleton() {
            return true;
        }

        @Required
        public void setCommandBus(DisruptorCommandBus commandBus) {
            this.commandBus = commandBus;
        }

        @Required
        public void setAggregateFactory(AggregateFactory<? extends EventSourcedAggregateRoot> factory) {
            this.factory = factory;
        }

        public void setEventStreamDecorators(List<EventStreamDecorator> decorators) {
            this.eventStreamDecorators.addAll(decorators);
        }

        public void setSnapshotterTrigger(SnapshotterTrigger snapshotterTrigger) {
            this.eventStreamDecorators.add(snapshotterTrigger);
        }
    }
}

