/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import org.axonframework.contextsupport.spring.AbstractSagaManagerBeanDefinitionParser;
import org.axonframework.contextsupport.spring.TransactionManagerFactoryBean;
import org.axonframework.saga.SagaManager;
import org.axonframework.saga.annotation.AsyncAnnotatedSagaManager;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AsyncSagaManagerBeanDefinitionParser
extends AbstractSagaManagerBeanDefinitionParser {
    private static final String EXECUTOR_ATTRIBUTE = "executor";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String PROCESSOR_COUNT_ATTRIBUTE = "processor-count";
    private static final String BUFFER_SIZE_ATTRIBUTE = "buffer-size";

    @Override
    protected void registerSpecificProperties(Element element, ParserContext parserContext, GenericBeanDefinition sagaManagerDefinition) {
        Element asyncElement = (Element)element.getElementsByTagName("axon:async").item(0);
        this.parseTransactionManagerAttribute(asyncElement, sagaManagerDefinition.getPropertyValues());
        this.parseExecutorAttribute(asyncElement, sagaManagerDefinition.getPropertyValues());
        this.parseProcessorCountAttribute(asyncElement, sagaManagerDefinition.getPropertyValues());
        this.parseBufferSizeAttribute(asyncElement, sagaManagerDefinition.getPropertyValues());
        sagaManagerDefinition.setInitMethodName("start");
        sagaManagerDefinition.setDestroyMethodName("stop");
    }

    @Override
    protected Class<? extends SagaManager> getBeanClass() {
        return AsyncAnnotatedSagaManager.class;
    }

    @Override
    protected void registerSagaRepository(Object sagaRepositoryDefinition, GenericBeanDefinition sagaManagerDefinition) {
        sagaManagerDefinition.getPropertyValues().add("sagaRepository", sagaRepositoryDefinition);
    }

    @Override
    protected void registerSagaFactory(Object sagaFactoryDefinition, GenericBeanDefinition sagaManagerDefinition) {
        sagaManagerDefinition.getPropertyValues().add("sagaFactory", sagaFactoryDefinition);
    }

    @Override
    protected void registerTypes(String[] types, GenericBeanDefinition sagaManagerDefinition, RuntimeBeanReference parameterResolverFactoryReference) {
        sagaManagerDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)parameterResolverFactoryReference);
        sagaManagerDefinition.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)types);
    }

    @Override
    protected void parseSuppressExceptionsAttribute(Element element, MutablePropertyValues beanDefinition) {
    }

    private void parseTransactionManagerAttribute(Element element, MutablePropertyValues propertyValues) {
        if (element.hasAttribute(TRANSACTION_MANAGER_ATTRIBUTE)) {
            AbstractBeanDefinition bd = BeanDefinitionBuilder.genericBeanDefinition(TransactionManagerFactoryBean.class).addPropertyReference("transactionManager", element.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE)).getBeanDefinition();
            propertyValues.addPropertyValue("transactionManager", (Object)bd);
        }
    }

    private void parseExecutorAttribute(Element element, MutablePropertyValues propertyValues) {
        if (element.hasAttribute(EXECUTOR_ATTRIBUTE)) {
            propertyValues.addPropertyValue(EXECUTOR_ATTRIBUTE, (Object)new RuntimeBeanReference(element.getAttribute(EXECUTOR_ATTRIBUTE)));
        }
    }

    private void parseProcessorCountAttribute(Element element, MutablePropertyValues propertyValues) {
        if (element.hasAttribute(PROCESSOR_COUNT_ATTRIBUTE)) {
            propertyValues.addPropertyValue("processorCount", (Object)element.getAttribute(PROCESSOR_COUNT_ATTRIBUTE));
        }
    }

    private void parseBufferSizeAttribute(Element element, MutablePropertyValues propertyValues) {
        if (element.hasAttribute(BUFFER_SIZE_ATTRIBUTE)) {
            propertyValues.addPropertyValue("bufferSize", (Object)element.getAttribute(BUFFER_SIZE_ATTRIBUTE));
        }
    }
}

