/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.contextsupport.spring;

import java.util.HashSet;
import java.util.Set;
import org.axonframework.contextsupport.spring.SpringContextParameterResolverFactoryBuilder;
import org.axonframework.saga.GenericSagaFactory;
import org.axonframework.saga.SagaManager;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.repository.inmemory.InMemorySagaRepository;
import org.axonframework.saga.spring.SpringResourceInjector;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractSagaManagerBeanDefinitionParser {
    private static final String DEFAULT_SAGA_REPOSITORY_ID = "sagaRepository$$DefaultInMemory";
    private static final String RESOURCE_INJECTOR_ATTRIBUTE = "resource-injector";
    private static final String SAGA_REPOSITORY_ATTRIBUTE = "saga-repository";
    private static final String CORRELATION_DATA_PROVIDER_ATTRIBUTE = "correlation-data-provider";
    private static final String SAGA_FACTORY_ATTRIBUTE = "saga-factory";
    private static final String REPLAYABLE_ATTRIBUTE = "replayable";
    private Object resourceInjector;

    protected final AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        GenericBeanDefinition sagaManagerDefinition = new GenericBeanDefinition();
        sagaManagerDefinition.setBeanClass(this.getBeanClass());
        this.parseResourceInjectorAttribute(element);
        this.parseSagaRepositoryAttribute(element, parserContext, sagaManagerDefinition);
        this.parseSagaFactoryAttribute(element, sagaManagerDefinition);
        this.parseTypesElement(element, sagaManagerDefinition, parserContext.getRegistry());
        this.parseSuppressExceptionsAttribute(element, sagaManagerDefinition.getPropertyValues());
        this.parseCorrelationDataProvderAttribute(element, sagaManagerDefinition.getPropertyValues());
        this.parseReplayableAttribute(element, sagaManagerDefinition.getPropertyValues());
        this.registerSpecificProperties(element, parserContext, sagaManagerDefinition);
        return sagaManagerDefinition;
    }

    private void parseCorrelationDataProvderAttribute(Element element, MutablePropertyValues properties) {
        if (element.hasAttribute(CORRELATION_DATA_PROVIDER_ATTRIBUTE)) {
            properties.add("correlationDataProvider", (Object)new RuntimeBeanReference(element.getAttribute(CORRELATION_DATA_PROVIDER_ATTRIBUTE)));
        }
    }

    protected abstract Class<? extends SagaManager> getBeanClass();

    protected abstract void registerSagaRepository(Object var1, GenericBeanDefinition var2);

    protected abstract void registerSagaFactory(Object var1, GenericBeanDefinition var2);

    protected abstract void registerTypes(String[] var1, GenericBeanDefinition var2, RuntimeBeanReference var3);

    protected abstract void registerSpecificProperties(Element var1, ParserContext var2, GenericBeanDefinition var3);

    private void parseSagaRepositoryAttribute(Element element, ParserContext context, GenericBeanDefinition sagaManagerDefinition) {
        if (element.hasAttribute(SAGA_REPOSITORY_ATTRIBUTE)) {
            this.registerSagaRepository(new RuntimeBeanReference(element.getAttribute(SAGA_REPOSITORY_ATTRIBUTE)), sagaManagerDefinition);
        } else {
            GenericBeanDefinition bean = new GenericBeanDefinition();
            bean.setBeanClass(InMemorySagaRepository.class);
            context.getRegistry().registerBeanDefinition(DEFAULT_SAGA_REPOSITORY_ID, (BeanDefinition)bean);
            this.registerSagaRepository(new RuntimeBeanReference(DEFAULT_SAGA_REPOSITORY_ID), sagaManagerDefinition);
        }
    }

    private void parseSagaFactoryAttribute(Element element, GenericBeanDefinition sagaManagerDefinition) {
        if (element.hasAttribute(SAGA_FACTORY_ATTRIBUTE)) {
            this.registerSagaFactory(new RuntimeBeanReference(element.getAttribute(SAGA_FACTORY_ATTRIBUTE)), sagaManagerDefinition);
        } else {
            GenericBeanDefinition defaultFactoryDefinition = new GenericBeanDefinition();
            defaultFactoryDefinition.setBeanClass(GenericSagaFactory.class);
            defaultFactoryDefinition.getPropertyValues().add("resourceInjector", this.getResourceInjector());
            this.registerSagaFactory(defaultFactoryDefinition, sagaManagerDefinition);
        }
    }

    private void parseResourceInjectorAttribute(Element element) {
        if (element.hasAttribute(RESOURCE_INJECTOR_ATTRIBUTE)) {
            this.resourceInjector = new RuntimeBeanReference(element.getAttribute(RESOURCE_INJECTOR_ATTRIBUTE));
        }
    }

    private void parseTypesElement(Element element, GenericBeanDefinition sagaManagerDefinition, BeanDefinitionRegistry registry) {
        HashSet<String> filteredTypes = new HashSet<String>();
        Element typeNode = DomUtils.getChildElementByTagName((Element)element, (String)"types");
        if (typeNode != null) {
            String[] types;
            for (String type : types = typeNode.getTextContent().split("[,\\n]")) {
                if (!StringUtils.hasText((String)type)) continue;
                filteredTypes.add(type.trim());
            }
        }
        if (element.hasAttribute("base-package")) {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractAnnotatedSaga.class));
            for (String basePackage : element.getAttribute("base-package").split(",")) {
                if (!StringUtils.hasText((String)basePackage)) continue;
                Set candidates = scanner.findCandidateComponents(basePackage.trim());
                for (BeanDefinition bd : candidates) {
                    filteredTypes.add(bd.getBeanClassName());
                }
            }
        }
        this.registerTypes(filteredTypes.toArray(new String[filteredTypes.size()]), sagaManagerDefinition, SpringContextParameterResolverFactoryBuilder.getBeanReference(registry));
    }

    protected abstract void parseSuppressExceptionsAttribute(Element var1, MutablePropertyValues var2);

    protected void parseReplayableAttribute(Element element, MutablePropertyValues propertyValues) {
        if (element.hasAttribute(REPLAYABLE_ATTRIBUTE)) {
            propertyValues.addPropertyValue(REPLAYABLE_ATTRIBUTE, (Object)element.getAttribute(REPLAYABLE_ATTRIBUTE));
        }
    }

    private Object getResourceInjector() {
        if (this.resourceInjector == null) {
            GenericBeanDefinition bean = new GenericBeanDefinition();
            bean.setBeanClass(SpringResourceInjector.class);
            this.resourceInjector = bean;
        }
        return this.resourceInjector;
    }
}

