/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.ConnectionWrapperFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class SpringDataSourceConnectionProvider
implements ConnectionProvider {
    private final DataSource dataSource;
    private final SpringConnectionCloseHandler closeHandler;

    public SpringDataSourceConnectionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
        this.closeHandler = new SpringConnectionCloseHandler(dataSource);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
        return ConnectionWrapperFactory.wrap(connection, this.closeHandler);
    }

    private static class SpringConnectionCloseHandler
    implements ConnectionWrapperFactory.ConnectionCloseHandler {
        private final DataSource dataSource;

        public SpringConnectionCloseHandler(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public void close(Connection delegate) {
            DataSourceUtils.releaseConnection((Connection)delegate, (DataSource)this.dataSource);
        }

        @Override
        public void commit(Connection connection) throws SQLException {
            if (!DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                connection.commit();
            }
        }
    }
}

