/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    private IOUtils() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietlyIfCloseable(Object closeable) {
        if (closeable instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)closeable);
        }
    }

    public static void closeIfCloseable(Object closeable) throws IOException {
        if (closeable instanceof Closeable) {
            ((Closeable)closeable).close();
        }
    }
}

