/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AbstractAnnotatedHandlerDefinition;
import org.axonframework.common.annotation.HandlerDefinition;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.annotation.UnsupportedHandlerException;
import org.axonframework.domain.Message;

public final class MethodMessageHandlerInspector {
    private final Class<?> targetType;
    private final List<MethodMessageHandler> handlers = new ArrayList<MethodMessageHandler>();
    private final ParameterResolverFactory parameterResolver;
    private static final ConcurrentMap<String, MethodMessageHandlerInspector> INSPECTORS = new ConcurrentHashMap<String, MethodMessageHandlerInspector>();

    public static <T extends Annotation> MethodMessageHandlerInspector getInstance(Class<?> handlerClass, Class<T> annotationType, ParameterResolverFactory parameterResolverFactory, boolean allowDuplicates) {
        return MethodMessageHandlerInspector.getInstance(handlerClass, parameterResolverFactory, allowDuplicates, new AnnotatedHandlerDefinition<T>(annotationType));
    }

    public static MethodMessageHandlerInspector getInstance(Class<?> handlerClass, ParameterResolverFactory parameterResolverFactory, boolean allowDuplicates, HandlerDefinition<? super Method> handlerDefinition) {
        String key = handlerDefinition.toString() + "@" + handlerClass.getName();
        MethodMessageHandlerInspector inspector = (MethodMessageHandlerInspector)INSPECTORS.get(key);
        while (inspector == null || !handlerClass.equals(inspector.getTargetType()) || !inspector.parameterResolver.equals(parameterResolverFactory)) {
            MethodMessageHandlerInspector newInspector = new MethodMessageHandlerInspector(parameterResolverFactory, handlerClass, allowDuplicates, handlerDefinition);
            if (inspector == null) {
                INSPECTORS.putIfAbsent(key, newInspector);
            } else {
                INSPECTORS.replace(key, inspector, newInspector);
            }
            inspector = (MethodMessageHandlerInspector)INSPECTORS.get(key);
        }
        return inspector;
    }

    public static void clearCache() {
        INSPECTORS.clear();
    }

    private MethodMessageHandlerInspector(ParameterResolverFactory parameterResolverFactory, Class<?> targetType, boolean allowDuplicates, HandlerDefinition<? super Method> handlerDefinition) {
        this.parameterResolver = parameterResolverFactory;
        this.targetType = targetType;
        Iterable<Method> methods = ReflectionUtils.methodsOf(targetType);
        TreeSet<MethodMessageHandler> uniqueHandlers = new TreeSet<MethodMessageHandler>();
        for (Method method : methods) {
            if (!handlerDefinition.isMessageHandler(method)) continue;
            Class<?> explicitPayloadType = handlerDefinition.resolvePayloadFor(method);
            MethodMessageHandler handlerMethod = MethodMessageHandler.createFor(method, explicitPayloadType, parameterResolverFactory);
            this.handlers.add(handlerMethod);
            if (allowDuplicates || uniqueHandlers.add(handlerMethod)) continue;
            MethodMessageHandler existing = uniqueHandlers.tailSet(handlerMethod).first();
            throw new UnsupportedHandlerException(String.format("The class %s contains two handler methods (%s and %s) that listen to the same Message type: %s", method.getDeclaringClass().getSimpleName(), handlerMethod.getMethodName(), existing.getMethodName(), handlerMethod.getPayloadType().getSimpleName()), method);
        }
        Collections.sort(this.handlers);
    }

    public MethodMessageHandler findHandlerMethod(Message message) {
        for (MethodMessageHandler handler : this.handlers) {
            if (!handler.matches(message)) continue;
            return handler;
        }
        return null;
    }

    public List<MethodMessageHandler> getHandlers() {
        return new ArrayList<MethodMessageHandler>(this.handlers);
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    private static class AnnotatedHandlerDefinition<T extends Annotation>
    extends AbstractAnnotatedHandlerDefinition<T> {
        protected AnnotatedHandlerDefinition(Class<T> annotationType) {
            super(annotationType);
        }

        @Override
        protected Class<?> getDefinedPayload(T annotation) {
            return null;
        }
    }
}

