/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import org.axonframework.common.CollectionUtils;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.MetaData;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.Message;

@Priority(value=0x7FFFFFFF)
public class DefaultParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    public ParameterResolver createInstance(Annotation[] methodAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        if (Message.class.isAssignableFrom(parameterType)) {
            return new MessageParameterResolver(parameterType);
        }
        if (CollectionUtils.getAnnotation(parameterAnnotations, MetaData.class) != null) {
            return new AnnotatedMetaDataParameterResolver(CollectionUtils.getAnnotation(parameterAnnotations, MetaData.class), parameterType);
        }
        if (org.axonframework.domain.MetaData.class.isAssignableFrom(parameterType)) {
            return MetaDataParameterResolver.INSTANCE;
        }
        return null;
    }

    private static class MessageParameterResolver
    implements ParameterResolver {
        private final Class<?> parameterType;

        public MessageParameterResolver(Class<?> parameterType) {
            this.parameterType = parameterType;
        }

        public Object resolveParameterValue(Message message) {
            return message;
        }

        @Override
        public boolean matches(Message message) {
            return this.parameterType.isInstance(message);
        }
    }

    private static final class MetaDataParameterResolver
    implements ParameterResolver {
        private static final MetaDataParameterResolver INSTANCE = new MetaDataParameterResolver();

        private MetaDataParameterResolver() {
        }

        public Object resolveParameterValue(Message message) {
            return message.getMetaData();
        }

        @Override
        public boolean matches(Message message) {
            return true;
        }
    }

    private static class AnnotatedMetaDataParameterResolver
    implements ParameterResolver {
        private final MetaData metaData;
        private final Class parameterType;

        public AnnotatedMetaDataParameterResolver(MetaData metaData, Class parameterType) {
            this.metaData = metaData;
            this.parameterType = parameterType;
        }

        public Object resolveParameterValue(Message message) {
            return message.getMetaData().get(this.metaData.value());
        }

        @Override
        public boolean matches(Message message) {
            return !this.parameterType.isPrimitive() && !this.metaData.required() || message.getMetaData().containsKey(this.metaData.value()) && this.parameterType.isInstance(message.getMetaData().get(this.metaData.value()));
        }
    }
}

