/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import org.axonframework.common.annotation.HandlerDefinition;

public abstract class AbstractAnnotatedHandlerDefinition<T extends Annotation>
implements HandlerDefinition<AccessibleObject> {
    private final Class<T> annotationType;

    protected AbstractAnnotatedHandlerDefinition(Class<T> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean isMessageHandler(AccessibleObject member) {
        return member.isAnnotationPresent(this.annotationType);
    }

    @Override
    public Class<?> resolvePayloadFor(AccessibleObject member) {
        T annotation = member.getAnnotation(this.annotationType);
        Class<?> definedPayload = null;
        if (annotation != null && (definedPayload = this.getDefinedPayload(annotation)) == Void.class) {
            return null;
        }
        return definedPayload;
    }

    protected abstract Class<?> getDefinedPayload(T var1);

    public String toString() {
        return "AnnotatedHandler{" + this.annotationType + '}';
    }
}

