/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.ThreadFactory;
import org.axonframework.common.Assert;

public class AxonThreadFactory
implements ThreadFactory {
    private final int priority;
    private final ThreadGroup groupName;

    public AxonThreadFactory(String groupName) {
        this(new ThreadGroup(groupName));
    }

    public AxonThreadFactory(ThreadGroup group) {
        this(5, group);
    }

    public AxonThreadFactory(int priority, ThreadGroup group) {
        Assert.isTrue(priority <= 10 && priority >= 1, "Given priority is invalid");
        this.priority = priority;
        this.groupName = group;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.groupName, r);
        thread.setPriority(this.priority);
        return thread;
    }
}

