/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.interceptors;

import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements CommandHandlerInterceptor {
    private final Logger logger;

    public LoggingInterceptor(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public LoggingInterceptor() {
        this.logger = LoggerFactory.getLogger(LoggingInterceptor.class);
    }

    @Override
    public Object handle(CommandMessage<?> command, UnitOfWork unitOfWork, InterceptorChain chain) throws Throwable {
        this.logger.info("Incoming command: [{}]", (Object)command.getPayloadType().getSimpleName());
        try {
            Object returnValue = chain.proceed();
            this.logger.info("[{}] executed successfully with a [{}] return value", (Object)command.getPayloadType().getSimpleName(), (Object)(returnValue == null ? "null" : returnValue.getClass().getSimpleName()));
            return returnValue;
        }
        catch (Throwable t) {
            this.logger.warn(String.format("[%s] execution failed:", command.getPayloadType().getSimpleName()), t);
            throw t;
        }
    }
}

