/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.ArrayList;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.unitofwork.CurrentUnitOfWork;

public class RetryingCallback<R>
implements CommandCallback<R> {
    private final CommandCallback<R> delegate;
    private final CommandMessage commandMessage;
    private final RetryScheduler retryScheduler;
    private final CommandBus commandBus;
    private final List<Class<? extends Throwable>[]> history;
    private final Runnable dispatchCommand;

    public RetryingCallback(CommandCallback<R> delegate, CommandMessage commandMessage, RetryScheduler retryScheduler, CommandBus commandBus) {
        this.delegate = delegate;
        this.commandMessage = commandMessage;
        this.retryScheduler = retryScheduler;
        this.commandBus = commandBus;
        this.history = new ArrayList<Class<? extends Throwable>[]>();
        this.dispatchCommand = new RetryDispatch();
    }

    @Override
    public void onSuccess(R result) {
        this.delegate.onSuccess(result);
    }

    @Override
    public void onFailure(Throwable cause) {
        this.history.add(this.simplify(cause));
        try {
            if (!(cause instanceof RuntimeException) || this.isCausedBy(cause, DeadlockException.class) && CurrentUnitOfWork.isStarted() || !this.retryScheduler.scheduleRetry(this.commandMessage, (RuntimeException)cause, new ArrayList<Class<? extends Throwable>[]>(this.history), this.dispatchCommand)) {
                this.delegate.onFailure(cause);
            }
        }
        catch (Exception e) {
            this.delegate.onFailure(e);
        }
    }

    private boolean isCausedBy(Throwable exception, Class<? extends Throwable> causeType) {
        return causeType.isInstance(exception) || exception.getCause() != null && this.isCausedBy(exception.getCause(), causeType);
    }

    private Class<? extends Throwable>[] simplify(Throwable cause) {
        ArrayList types = new ArrayList();
        types.add(cause.getClass());
        Throwable rootCause = cause;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
            types.add(rootCause.getClass());
        }
        return types.toArray(new Class[types.size()]);
    }

    private class RetryDispatch
    implements Runnable {
        private RetryDispatch() {
        }

        @Override
        public void run() {
            try {
                RetryingCallback.this.commandBus.dispatch(RetryingCallback.this.commandMessage, RetryingCallback.this);
            }
            catch (Exception e) {
                RetryingCallback.this.onFailure(e);
            }
        }
    }
}

