/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.GatewayProxyFactory;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class CommandGatewayFactoryBean<T>
implements FactoryBean<T>,
InitializingBean {
    private CommandBus commandBus;
    private RetryScheduler retryScheduler;
    private List<CommandDispatchInterceptor> dispatchInterceptors = Collections.emptyList();
    private List<CommandCallback<?>> commandCallbacks = Collections.emptyList();
    private T gateway;
    private Class<T> gatewayInterface;

    public T getObject() throws Exception {
        if (this.gateway == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.gateway;
    }

    public Class<?> getObjectType() {
        return this.gatewayInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.commandBus == null) {
            throw new AxonConfigurationException("CommandBus may not be null");
        }
        if (this.gatewayInterface == null) {
            this.gatewayInterface = CommandGateway.class;
        }
        GatewayProxyFactory factory = new GatewayProxyFactory(this.commandBus, this.retryScheduler, this.dispatchInterceptors);
        for (CommandCallback<?> commandCallback : this.commandCallbacks) {
            factory.registerCommandCallback(commandCallback);
        }
        this.gateway = factory.createGateway(this.gatewayInterface);
    }

    @Required
    public void setCommandBus(CommandBus commandBus) {
        this.commandBus = commandBus;
    }

    public void setRetryScheduler(RetryScheduler retryScheduler) {
        this.retryScheduler = retryScheduler;
    }

    public void setGatewayInterface(Class<T> gatewayInterface) {
        Assert.notNull(gatewayInterface, "The given gateway interface may not be null");
        Assert.isTrue(gatewayInterface.isInterface(), "The given gateway interface must be an interface");
        this.gatewayInterface = gatewayInterface;
    }

    public void setCommandDispatchInterceptors(CommandDispatchInterceptor ... commandDispatchInterceptors) {
        this.setCommandDispatchInterceptors(Arrays.asList(commandDispatchInterceptors));
    }

    public void setCommandDispatchInterceptors(List<CommandDispatchInterceptor> commandDispatchInterceptors) {
        this.dispatchInterceptors = commandDispatchInterceptors;
    }

    public void setCommandCallbacks(List<CommandCallback<?>> commandCallbacks) {
        this.commandCallbacks = commandCallbacks;
    }
}

