/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.RetryingCallback;
import org.axonframework.common.Assert;
import org.axonframework.correlation.CorrelationDataHolder;
import org.axonframework.domain.MetaData;

public abstract class AbstractCommandGateway {
    private final CommandBus commandBus;
    private final RetryScheduler retryScheduler;
    private final List<CommandDispatchInterceptor> dispatchInterceptors;

    protected AbstractCommandGateway(CommandBus commandBus, RetryScheduler retryScheduler, List<CommandDispatchInterceptor> commandDispatchInterceptors) {
        Assert.notNull(commandBus, "commandBus may not be null");
        this.commandBus = commandBus;
        this.dispatchInterceptors = commandDispatchInterceptors != null && !commandDispatchInterceptors.isEmpty() ? new ArrayList<CommandDispatchInterceptor>(commandDispatchInterceptors) : Collections.emptyList();
        this.retryScheduler = retryScheduler;
    }

    protected <R> void send(Object command, CommandCallback<R> callback) {
        CommandMessage commandMessage = this.processInterceptors(this.createCommandMessage(command));
        CommandCallback<R> commandCallback = callback;
        if (this.retryScheduler != null) {
            commandCallback = new RetryingCallback<R>(callback, commandMessage, this.retryScheduler, this.commandBus);
        }
        this.commandBus.dispatch(commandMessage, commandCallback);
    }

    protected void sendAndForget(Object command) {
        if (this.retryScheduler == null) {
            this.commandBus.dispatch(this.processInterceptors(this.createCommandMessage(command)));
        } else {
            CommandMessage commandMessage = this.createCommandMessage(command);
            this.send(commandMessage, new LoggingCallback(commandMessage));
        }
    }

    private CommandMessage createCommandMessage(Object command) {
        CommandMessage message = GenericCommandMessage.asCommandMessage(command);
        return message.withMetaData(MetaData.from(CorrelationDataHolder.getCorrelationData()).mergedWith(message.getMetaData()));
    }

    protected CommandMessage processInterceptors(CommandMessage commandMessage) {
        CommandMessage<?> message = commandMessage;
        for (CommandDispatchInterceptor dispatchInterceptor : this.dispatchInterceptors) {
            message = dispatchInterceptor.handle(message);
        }
        return message;
    }
}

