/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.EventHandler;
import org.axonframework.commandhandling.disruptor.CommandHandlingEntry;
import org.axonframework.domain.EventMessage;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.Serializer;

public class SerializerHandler
implements EventHandler<CommandHandlingEntry> {
    private final Serializer serializer;
    private final int serializerId;
    private final Class<?> serializedRepresentation;

    public SerializerHandler(Serializer serializer, int serializerSegmentId, Class<?> serializedRepresentation) {
        this.serializer = serializer;
        this.serializerId = serializerSegmentId;
        this.serializedRepresentation = serializedRepresentation;
    }

    public void onEvent(CommandHandlingEntry event, long sequence, boolean endOfBatch) throws Exception {
        if (event.getSerializerSegmentId() == this.serializerId) {
            for (EventMessage eventMessage : event.getUnitOfWork().getEventsToPublish()) {
                if (!(eventMessage instanceof SerializationAware)) continue;
                ((SerializationAware)((Object)eventMessage)).serializePayload(this.serializer, this.serializedRepresentation);
                ((SerializationAware)((Object)eventMessage)).serializeMetaData(this.serializer, this.serializedRepresentation);
            }
        }
    }
}

