/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.EventRegistrationCallback;
import org.axonframework.domain.SimpleDomainEventStream;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventStreamDecorator;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.SaveAggregateCallback;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListener;
import org.axonframework.unitofwork.UnitOfWorkListenerCollection;

public class DisruptorUnitOfWork
implements UnitOfWork,
EventRegistrationCallback {
    private static final DomainEventStream EMPTY_DOMAIN_EVENT_STREAM = new SimpleDomainEventStream(new DomainEventMessage[0]);
    private DomainEventStream eventsToStore = EMPTY_DOMAIN_EVENT_STREAM;
    private final List<EventMessage> eventsToPublish = new ArrayList<EventMessage>();
    private final UnitOfWorkListenerCollection listeners = new UnitOfWorkListenerCollection();
    private final boolean transactional;
    private final Map<String, Object> resources = new HashMap<String, Object>();
    private final Map<String, Object> inheritedResources = new HashMap<String, Object>();
    private boolean committed;
    private Throwable rollbackReason;
    private EventSourcedAggregateRoot aggregate;
    private String aggregateType;
    private EventStreamDecorator eventStreamDecorator;

    public DisruptorUnitOfWork(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    public void commit() {
        this.committed = true;
        if (this.aggregate != null) {
            this.eventsToStore = this.aggregate.getUncommittedEvents();
            this.aggregate.commitEvents();
        }
        CurrentUnitOfWork.clear(this);
    }

    public void onPrepareCommit() {
        this.listeners.onPrepareCommit(this, this.aggregate != null ? Collections.singleton(this.aggregate) : Collections.emptySet(), this.eventsToPublish);
    }

    public void onPrepareTransactionCommit(Object transaction) {
        this.listeners.onPrepareTransactionCommit(this, transaction);
    }

    public void onAfterCommit() {
        this.listeners.afterCommit(this);
    }

    public void onCleanup() {
        this.listeners.onCleanup(this);
        this.eventsToStore = EMPTY_DOMAIN_EVENT_STREAM;
        this.eventsToPublish.clear();
        this.eventStreamDecorator = null;
        this.resources.clear();
        this.inheritedResources.clear();
    }

    public void onRollback(Throwable cause) {
        this.listeners.onRollback(this, cause);
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    @Override
    public void rollback(Throwable cause) {
        this.rollbackReason = cause;
        if (this.aggregate != null) {
            this.aggregate.commitEvents();
        }
        CurrentUnitOfWork.clear(this);
    }

    @Override
    public void start() {
        CurrentUnitOfWork.set(this);
    }

    @Override
    public boolean isStarted() {
        return !this.committed && this.rollbackReason == null;
    }

    @Override
    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public void registerListener(UnitOfWorkListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public <T extends AggregateRoot> T registerAggregate(T aggregateRoot, EventBus eventBus, SaveAggregateCallback<T> saveAggregateCallback) {
        if (this.aggregateType == null) {
            throw new IllegalStateException("Cannot register an aggregate if the aggregate type of this Unit of Work hasn't been set.");
        }
        if (this.aggregate != null && aggregateRoot != this.aggregate) {
            throw new IllegalArgumentException("Cannot register more than one aggregate in this Unit Of Work. Either ensure each command executes against at most one aggregate, or use another Command Bus implementation.");
        }
        this.aggregate = (EventSourcedAggregateRoot)aggregateRoot;
        this.aggregate.addEventRegistrationCallback(this);
        return (T)this.aggregate;
    }

    @Override
    public void attachResource(String name, Object resource) {
        this.resources.put(name, resource);
        this.inheritedResources.remove(name);
    }

    @Override
    public void attachResource(String name, Object resource, boolean inherited) {
        this.resources.put(name, resource);
        if (inherited) {
            this.inheritedResources.put(name, resource);
        } else {
            this.inheritedResources.remove(name);
        }
    }

    @Override
    public <T> T getResource(String name) {
        return (T)this.resources.get(name);
    }

    @Override
    public void attachInheritedResources(UnitOfWork inheritingUnitOfWork) {
        for (Map.Entry<String, Object> entry : this.inheritedResources.entrySet()) {
            inheritingUnitOfWork.attachResource(entry.getKey(), entry.getValue(), true);
        }
    }

    public void publishEvent(EventMessage event, EventBus eventBus) {
        this.eventsToPublish.add(this.listeners.onEventRegistered(this, event));
    }

    public DomainEventStream getEventsToStore() {
        if (this.eventStreamDecorator == null) {
            return this.eventsToStore;
        }
        return this.eventStreamDecorator.decorateForAppend(this.aggregateType, this.aggregate, this.eventsToStore);
    }

    public List<EventMessage> getEventsToPublish() {
        return this.eventsToPublish;
    }

    public EventSourcedAggregateRoot getAggregate() {
        return this.aggregate;
    }

    @Override
    public <T> DomainEventMessage<T> onRegisteredEvent(DomainEventMessage<T> event) {
        DomainEventMessage message = (DomainEventMessage)this.listeners.onEventRegistered(this, event);
        this.eventsToPublish.add(message);
        return message;
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(String aggregateType) {
        this.aggregateType = aggregateType;
    }

    public void setEventStreamDecorator(EventStreamDecorator eventStreamDecorator) {
        this.eventStreamDecorator = eventStreamDecorator;
    }
}

