/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.disruptor;

import com.lmax.disruptor.RingBuffer;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.disruptor.AggregateBlacklistedException;
import org.axonframework.commandhandling.disruptor.AggregateStateCorruptedException;
import org.axonframework.commandhandling.disruptor.CommandHandlingEntry;
import org.axonframework.commandhandling.disruptor.DisruptorCommandBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistDetectingCallback<R>
implements CommandCallback<R> {
    private static final Logger logger = LoggerFactory.getLogger(BlacklistDetectingCallback.class);
    private final CommandCallback<R> delegate;
    private final CommandMessage command;
    private final RingBuffer<CommandHandlingEntry> ringBuffer;
    private final DisruptorCommandBus commandBus;
    private final boolean rescheduleOnCorruptState;

    public BlacklistDetectingCallback(CommandCallback<R> delegate, CommandMessage command, RingBuffer<CommandHandlingEntry> ringBuffer, DisruptorCommandBus commandBus, boolean rescheduleOnCorruptState) {
        this.delegate = delegate;
        this.command = command;
        this.ringBuffer = ringBuffer;
        this.commandBus = commandBus;
        this.rescheduleOnCorruptState = rescheduleOnCorruptState;
    }

    @Override
    public void onSuccess(R result) {
        if (this.delegate != null) {
            this.delegate.onSuccess(result);
        }
    }

    @Override
    public void onFailure(Throwable cause) {
        if (cause instanceof AggregateBlacklistedException) {
            long sequence = this.ringBuffer.next();
            CommandHandlingEntry event = (CommandHandlingEntry)this.ringBuffer.get(sequence);
            event.resetAsRecoverEntry(((AggregateBlacklistedException)cause).getAggregateIdentifier());
            this.ringBuffer.publish(sequence);
            if (this.delegate != null) {
                this.delegate.onFailure(cause.getCause());
            }
        } else if (this.rescheduleOnCorruptState && cause instanceof AggregateStateCorruptedException) {
            this.commandBus.doDispatch(this.command, this.delegate);
        } else if (this.delegate != null) {
            this.delegate.onFailure(cause);
        } else {
            logger.warn("Command {} resulted in an exception:", (Object)this.command.getPayloadType().getSimpleName(), (Object)cause);
        }
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }
}

