/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.callbacks;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;

public class FutureCallback<R>
implements CommandCallback<R>,
Future<R> {
    private volatile R result;
    private volatile Throwable failure;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onSuccess(R executionResult) {
        this.result = executionResult;
        this.latch.countDown();
    }

    @Override
    public void onFailure(Throwable cause) {
        this.failure = cause;
        this.latch.countDown();
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            this.latch.await();
        }
        return this.getFutureResult();
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        if (!this.isDone() && !this.latch.await(timeout, unit)) {
            throw new TimeoutException("A Timeout occurred while waiting for a Command Callback");
        }
        return this.getFutureResult();
    }

    public R getResult() {
        if (!this.isDone()) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.doGetResult();
    }

    public R getResult(long timeout, TimeUnit unit) {
        if (!this.awaitCompletion(timeout, unit)) {
            return null;
        }
        return this.doGetResult();
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) {
        try {
            return this.isDone() || this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    private R doGetResult() {
        if (this.failure != null) {
            if (this.failure instanceof Error) {
                throw (Error)this.failure;
            }
            if (this.failure instanceof RuntimeException) {
                throw (RuntimeException)this.failure;
            }
            throw new CommandExecutionException("An exception occurred while executing a command", this.failure);
        }
        return this.result;
    }

    private R getFutureResult() throws ExecutionException {
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }
}

