/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.VersionedAggregateIdentifier;
import org.axonframework.commandhandling.annotation.TargetAggregateIdentifier;
import org.axonframework.commandhandling.annotation.TargetAggregateVersion;
import org.axonframework.common.ReflectionUtils;

public class AnnotationCommandTargetResolver
implements CommandTargetResolver {
    @Override
    public VersionedAggregateIdentifier resolveTarget(CommandMessage<?> command) {
        Long aggregateVersion;
        Object aggregateIdentifier;
        try {
            aggregateIdentifier = this.findIdentifier(command);
            aggregateVersion = this.findVersion(command);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("An exception occurred while extracting aggregate information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The current security context does not allow extraction of aggregate information from the given command.", e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value provided for the version is not a number.", e);
        }
        if (aggregateIdentifier == null) {
            throw new IllegalArgumentException(String.format("Invalid command. It does not identify the target aggregate. Make sure at least one of the fields or methods in the [%s] class contains the @TargetAggregateIdentifier annotation and that it returns a non-null value.", command.getPayloadType().getSimpleName()));
        }
        return new VersionedAggregateIdentifier(aggregateIdentifier, aggregateVersion);
    }

    private <I> I findIdentifier(CommandMessage<?> command) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ReflectionUtils.methodsOf(command.getPayloadType())) {
            if (!m.isAnnotationPresent(TargetAggregateIdentifier.class)) continue;
            ReflectionUtils.ensureAccessible(m);
            return (I)m.invoke(command.getPayload(), new Object[0]);
        }
        for (Field f : ReflectionUtils.fieldsOf(command.getPayloadType())) {
            if (!f.isAnnotationPresent(TargetAggregateIdentifier.class)) continue;
            return (I)ReflectionUtils.getFieldValue(f, command.getPayload());
        }
        return null;
    }

    private Long findVersion(CommandMessage<?> command) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ReflectionUtils.methodsOf(command.getPayloadType())) {
            if (!m.isAnnotationPresent(TargetAggregateVersion.class)) continue;
            ReflectionUtils.ensureAccessible(m);
            return this.asLong(m.invoke(command.getPayload(), new Object[0]));
        }
        for (Field f : ReflectionUtils.fieldsOf(command.getPayloadType())) {
            if (!f.isAnnotationPresent(TargetAggregateVersion.class)) continue;
            return this.asLong(ReflectionUtils.getFieldValue(f, command.getPayload()));
        }
        return null;
    }

    private Long asLong(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (Number.class.isInstance(fieldValue)) {
            return ((Number)fieldValue).longValue();
        }
        return Long.parseLong(fieldValue.toString());
    }
}

