/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.annotation.CommandHandler;
import org.axonframework.commandhandling.annotation.CommandHandlingMember;
import org.axonframework.commandhandling.annotation.CommandHandlingMemberCollection;
import org.axonframework.commandhandling.annotation.CommandHandlingMemberMap;
import org.axonframework.commandhandling.annotation.ConstructorCommandMessageHandler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AbstractMessageHandler;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.annotation.MethodMessageHandlerInspector;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.domain.Message;
import org.axonframework.eventsourcing.annotation.AbstractAnnotatedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateCommandHandlerInspector<T extends AggregateRoot> {
    private static final Logger logger = LoggerFactory.getLogger(AggregateCommandHandlerInspector.class);
    private final List<ConstructorCommandMessageHandler<T>> constructorCommandHandlers = new LinkedList<ConstructorCommandMessageHandler<T>>();
    private final List<AbstractMessageHandler> handlers;

    protected AggregateCommandHandlerInspector(Class<T> targetType, ParameterResolverFactory parameterResolverFactory) {
        MethodMessageHandlerInspector inspector = MethodMessageHandlerInspector.getInstance(targetType, CommandHandler.class, parameterResolverFactory, true);
        this.handlers = new ArrayList<MethodMessageHandler>(inspector.getHandlers());
        this.processNestedEntityCommandHandlers(targetType, parameterResolverFactory, new RootEntityAccessor(targetType));
        for (Constructor<?> constructor : targetType.getConstructors()) {
            if (!constructor.isAnnotationPresent(CommandHandler.class)) continue;
            this.constructorCommandHandlers.add(ConstructorCommandMessageHandler.forConstructor(constructor, parameterResolverFactory));
        }
    }

    private void processNestedEntityCommandHandlers(Class<?> targetType, ParameterResolverFactory parameterResolverFactory, EntityAccessor entityAccessor) {
        for (Field field : ReflectionUtils.fieldsOf(targetType)) {
            Class<? extends AbstractAnnotatedEntity> entityType;
            Annotation annotation;
            EntityAccessor newEntityAccessor = null;
            if (field.isAnnotationPresent(CommandHandlingMember.class)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Field {}.{} is annotated with @CommandHandlingMember. Checking {} for Command Handlers", new Object[]{targetType.getSimpleName(), field.getName(), field.getType().getSimpleName()});
                }
                newEntityAccessor = new EntityFieldAccessor(entityAccessor, field);
            } else if (field.isAnnotationPresent(CommandHandlingMemberCollection.class)) {
                annotation = field.getAnnotation(CommandHandlingMemberCollection.class);
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    throw new AxonConfigurationException(String.format("Field %s.%s is annotated with @CommandHandlingMemberCollection, but the declared type of the field is not assignable to java.util.Collection.", targetType.getSimpleName(), field.getName()));
                }
                entityType = this.determineEntityType(annotation.entityType(), field, 0);
                if (entityType == null) {
                    throw new AxonConfigurationException(String.format("Field %s.%s is annotated with @CommandHandlingMemberCollection, but the entity type is not indicated on the annotation, nor can it be deduced from the generic parameters", targetType.getSimpleName(), field.getName()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Field {}.{} is annotated with @CommandHandlingMemberCollection. Checking {} for Command Handlers", new Object[]{targetType.getSimpleName(), field.getName(), entityType.getSimpleName()});
                }
                newEntityAccessor = new EntityCollectionFieldAccessor(entityType, (CommandHandlingMemberCollection)annotation, entityAccessor, field);
            } else if (field.isAnnotationPresent(CommandHandlingMemberMap.class)) {
                annotation = field.getAnnotation(CommandHandlingMemberMap.class);
                if (!Map.class.isAssignableFrom(field.getType())) {
                    throw new AxonConfigurationException(String.format("Field %s.%s is annotated with @CommandHandlingMemberMap, but the declared type of the field is not assignable to java.util.Map.", targetType.getSimpleName(), field.getName()));
                }
                entityType = this.determineEntityType(annotation.entityType(), field, 1);
                if (entityType == null) {
                    throw new AxonConfigurationException(String.format("Field %s.%s is annotated with @CommandHandlingMemberMap, but the entity type is not indicated on the annotation, nor can it be deduced from the generic parameters", targetType.getSimpleName(), field.getName()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Field {}.{} is annotated with @CommandHandlingMemberMap. Checking {} for Command Handlers", new Object[]{targetType.getSimpleName(), field.getName(), entityType.getSimpleName()});
                }
                newEntityAccessor = new EntityMapFieldAccessor(entityType, (CommandHandlingMemberMap)annotation, entityAccessor, field);
            }
            if (newEntityAccessor == null) continue;
            MethodMessageHandlerInspector fieldInspector = MethodMessageHandlerInspector.getInstance(newEntityAccessor.entityType(), CommandHandler.class, parameterResolverFactory, true);
            for (MethodMessageHandler fieldHandler : fieldInspector.getHandlers()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found a Command Handler in {} on field {}.{}", new Object[]{field.getType().getSimpleName(), entityAccessor.entityType().getName(), field.getName()});
                }
                this.handlers.add(new EntityForwardingMethodMessageHandler(newEntityAccessor, fieldHandler));
            }
            this.processNestedEntityCommandHandlers(field.getType(), parameterResolverFactory, newEntityAccessor);
        }
    }

    private Class<?> determineEntityType(Class<?> entityType, Field field, int genericTypeIndex) {
        if (AbstractAnnotatedEntity.class.equals(entityType)) {
            Type genericType = field.getGenericType();
            if (genericType == null || !(genericType instanceof ParameterizedType) || ((ParameterizedType)genericType).getActualTypeArguments().length == 0) {
                return null;
            }
            entityType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[genericTypeIndex];
        }
        return entityType;
    }

    public List<ConstructorCommandMessageHandler<T>> getConstructorHandlers() {
        return this.constructorCommandHandlers;
    }

    public List<AbstractMessageHandler> getHandlers() {
        return this.handlers;
    }

    private class EntityMapFieldAccessor
    extends MultipleEntityFieldAccessor<Map<?, ?>> {
        public EntityMapFieldAccessor(Class entityType, CommandHandlingMemberMap annotation, EntityAccessor entityAccessor, Field field) {
            super(entityType, annotation.commandTargetProperty(), entityAccessor, field);
        }

        @Override
        protected Object getEntity(Map<?, ?> entities, Object commandId) {
            return entities.get(commandId);
        }
    }

    private class EntityCollectionFieldAccessor
    extends MultipleEntityFieldAccessor<Collection<?>> {
        private final Property<Object> entityProperty;

        public EntityCollectionFieldAccessor(Class entityType, CommandHandlingMemberCollection annotation, EntityAccessor entityAccessor, Field field) {
            super(entityType, annotation.commandTargetProperty(), entityAccessor, field);
            this.entityProperty = PropertyAccessStrategy.getProperty(entityType, annotation.entityId());
        }

        @Override
        protected Object getEntity(Collection<?> entities, Object commandId) {
            for (Object entity : entities) {
                Object entityId = this.entityProperty.getValue(entity);
                if (entityId == null || !entityId.equals(commandId)) continue;
                return entity;
            }
            return null;
        }
    }

    private abstract class MultipleEntityFieldAccessor<T>
    implements EntityAccessor {
        private final Class<?> entityType;
        private final EntityAccessor entityAccessor;
        private final Field field;
        private String commandTargetProperty;

        public MultipleEntityFieldAccessor(Class entityType, String commandTargetProperty, EntityAccessor entityAccessor, Field field) {
            this.entityType = entityType;
            this.entityAccessor = entityAccessor;
            this.commandTargetProperty = commandTargetProperty;
            this.field = field;
        }

        @Override
        public Object getInstance(Object aggregateRoot, CommandMessage<?> command) throws IllegalAccessException {
            Object parentEntity = this.entityAccessor.getInstance(aggregateRoot, command);
            if (parentEntity == null) {
                return null;
            }
            Object entityCollection = ReflectionUtils.getFieldValue(this.field, parentEntity);
            Property commandProperty = PropertyAccessStrategy.getProperty(command.getPayloadType(), this.commandTargetProperty);
            if (commandProperty == null) {
                return null;
            }
            Object commandId = commandProperty.getValue(command.getPayload());
            if (commandId == null) {
                return null;
            }
            return this.getEntity(entityCollection, commandId);
        }

        protected abstract Object getEntity(T var1, Object var2);

        @Override
        public Class<?> entityType() {
            return this.entityType;
        }
    }

    private static class RootEntityAccessor
    implements EntityAccessor {
        private final Class<?> entityType;

        private RootEntityAccessor(Class<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Object getInstance(Object aggregateRoot, CommandMessage<?> commandMessage) {
            return aggregateRoot;
        }

        @Override
        public Class<?> entityType() {
            return this.entityType;
        }
    }

    private static class EntityFieldAccessor
    implements EntityAccessor {
        private final EntityAccessor entityAccessor;
        private final Field field;

        public EntityFieldAccessor(EntityAccessor parent, Field field) {
            this.entityAccessor = parent;
            this.field = field;
        }

        @Override
        public Class<?> entityType() {
            return this.field.getType();
        }

        @Override
        public Object getInstance(Object aggregateRoot, CommandMessage<?> commandMessage) throws IllegalAccessException {
            Object entity = this.entityAccessor.getInstance(aggregateRoot, commandMessage);
            return entity != null ? ReflectionUtils.getFieldValue(this.field, entity) : null;
        }
    }

    private static class EntityForwardingMethodMessageHandler
    extends AbstractMessageHandler {
        private final AbstractMessageHandler handler;
        private final EntityAccessor entityAccessor;

        public EntityForwardingMethodMessageHandler(EntityAccessor entityAccessor, AbstractMessageHandler handler) {
            super(handler);
            this.entityAccessor = entityAccessor;
            this.handler = handler;
        }

        @Override
        public Object invoke(Object target, Message message) throws InvocationTargetException, IllegalAccessException {
            Object entity = this.entityAccessor.getInstance(target, (CommandMessage)message);
            if (entity == null) {
                throw new IllegalStateException("No appropriate entity available in the aggregate. The command cannot be handled.");
            }
            return this.handler.invoke(entity, message);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.handler.getAnnotation(annotationType);
        }
    }

    private static interface EntityAccessor {
        public Object getInstance(Object var1, CommandMessage<?> var2) throws IllegalAccessException;

        public Class<?> entityType();
    }
}

