/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandDispatchInterceptor;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DefaultInterceptorChain;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.RollbackConfiguration;
import org.axonframework.commandhandling.RollbackOnUncheckedExceptionConfiguration;
import org.axonframework.commandhandling.SimpleCommandBusStatistics;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.monitoring.MonitorRegistry;
import org.axonframework.unitofwork.DefaultUnitOfWorkFactory;
import org.axonframework.unitofwork.TransactionManager;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCommandBus
implements CommandBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCommandBus.class);
    private final ConcurrentMap<String, CommandHandler<?>> subscriptions = new ConcurrentHashMap();
    private final SimpleCommandBusStatistics statistics = new SimpleCommandBusStatistics();
    private volatile Iterable<? extends CommandHandlerInterceptor> handlerInterceptors = Collections.emptyList();
    private volatile Iterable<? extends CommandDispatchInterceptor> dispatchInterceptors = Collections.emptyList();
    private UnitOfWorkFactory unitOfWorkFactory = new DefaultUnitOfWorkFactory();
    private RollbackConfiguration rollbackConfiguration = new RollbackOnUncheckedExceptionConfiguration();

    public SimpleCommandBus() {
        MonitorRegistry.registerMonitoringBean(this.statistics, SimpleCommandBus.class);
    }

    @Override
    public void dispatch(CommandMessage<?> command) {
        this.doDispatch(this.intercept(command), new LoggingCallback(command));
    }

    @Override
    public <R> void dispatch(CommandMessage<?> command, CommandCallback<R> callback) {
        this.doDispatch(this.intercept(command), callback);
    }

    protected CommandMessage<?> intercept(CommandMessage<?> command) {
        CommandMessage<?> commandToDispatch = command;
        for (CommandDispatchInterceptor commandDispatchInterceptor : this.dispatchInterceptors) {
            commandToDispatch = commandDispatchInterceptor.handle(commandToDispatch);
        }
        return commandToDispatch;
    }

    protected <R> void doDispatch(CommandMessage<?> command, CommandCallback<R> callback) {
        try {
            CommandHandler handler = this.findCommandHandlerFor(command);
            Object result = this.doDispatch(command, handler);
            callback.onSuccess(result);
        }
        catch (Throwable throwable) {
            callback.onFailure(throwable);
        }
    }

    private CommandHandler findCommandHandlerFor(CommandMessage<?> command) {
        CommandHandler handler = (CommandHandler)this.subscriptions.get(command.getCommandName());
        if (handler == null) {
            throw new NoHandlerForCommandException(String.format("No handler was subscribed to command [%s]", command.getCommandName()));
        }
        return handler;
    }

    private Object doDispatch(CommandMessage<?> command, CommandHandler commandHandler) throws Throwable {
        Object returnValue;
        logger.debug("Dispatching command [{}]", (Object)command.getCommandName());
        this.statistics.recordReceivedCommand();
        UnitOfWork unitOfWork = this.unitOfWorkFactory.createUnitOfWork();
        DefaultInterceptorChain chain = new DefaultInterceptorChain(command, unitOfWork, commandHandler, this.handlerInterceptors);
        try {
            returnValue = chain.proceed();
        }
        catch (Throwable throwable) {
            if (this.rollbackConfiguration.rollBackOn(throwable)) {
                unitOfWork.rollback(throwable);
            } else {
                unitOfWork.commit();
            }
            throw throwable;
        }
        unitOfWork.commit();
        return returnValue;
    }

    public <T> void subscribe(String commandName, CommandHandler<? super T> handler) {
        this.subscriptions.put(commandName, handler);
        this.statistics.reportHandlerRegistered(commandName);
    }

    public <T> boolean unsubscribe(String commandName, CommandHandler<? super T> handler) {
        if (this.subscriptions.remove(commandName, handler)) {
            this.statistics.recordUnregisteredHandler(commandName);
            return true;
        }
        return false;
    }

    public void setHandlerInterceptors(List<? extends CommandHandlerInterceptor> handlerInterceptors) {
        this.handlerInterceptors = new ArrayList<CommandHandlerInterceptor>(handlerInterceptors);
    }

    public void setDispatchInterceptors(List<? extends CommandDispatchInterceptor> dispatchInterceptors) {
        this.dispatchInterceptors = new ArrayList<CommandDispatchInterceptor>(dispatchInterceptors);
    }

    public void setSubscriptions(Map<?, ?> handlers) {
        for (Map.Entry<?, ?> entry : handlers.entrySet()) {
            String commandName = entry.getKey() instanceof Class ? ((Class)entry.getKey()).getName() : entry.getKey().toString();
            this.subscribe(commandName, (CommandHandler)entry.getValue());
        }
    }

    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.unitOfWorkFactory = new DefaultUnitOfWorkFactory(transactionManager);
    }

    public void setRollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
        this.rollbackConfiguration = rollbackConfiguration;
    }
}

