/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandTargetResolver;
import org.axonframework.commandhandling.VersionedAggregateIdentifier;
import org.axonframework.common.Assert;

public class MetaDataCommandTargetResolver
implements CommandTargetResolver {
    private final String identifierKey;
    private final String versionKey;

    public MetaDataCommandTargetResolver(String identifierKey) {
        this(identifierKey, null);
    }

    public MetaDataCommandTargetResolver(String identifierKey, String versionKey) {
        this.versionKey = versionKey;
        this.identifierKey = identifierKey;
    }

    @Override
    public VersionedAggregateIdentifier resolveTarget(CommandMessage<?> command) {
        Object identifier = command.getMetaData().get(this.identifierKey);
        Assert.notNull(identifier, "The MetaData for the command does not exist or contains a null value");
        Long version = (Long)(this.versionKey == null ? null : command.getMetaData().get(this.versionKey));
        return new VersionedAggregateIdentifier(identifier, version);
    }
}

