/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.Map;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.domain.IdentifierFactory;
import org.axonframework.domain.MetaData;

public class GenericCommandMessage<T>
implements CommandMessage<T> {
    private static final long serialVersionUID = 8754588074137370013L;
    private final String identifier;
    private final String commandName;
    private final T payload;
    private final MetaData metaData;

    public static CommandMessage asCommandMessage(Object command) {
        if (CommandMessage.class.isInstance(command)) {
            return (CommandMessage)command;
        }
        return new GenericCommandMessage<Object>(command);
    }

    public GenericCommandMessage(T payload) {
        this(payload, MetaData.emptyInstance());
    }

    public GenericCommandMessage(T payload, Map<String, ?> newMetaData) {
        this(payload.getClass().getName(), payload, newMetaData);
    }

    public GenericCommandMessage(String commandName, T payload, Map<String, ?> newMetaData) {
        this.commandName = commandName;
        this.payload = payload;
        this.metaData = MetaData.from(newMetaData);
        this.identifier = IdentifierFactory.getInstance().generateIdentifier();
    }

    public GenericCommandMessage(String identifier, String commandName, T payload, Map<String, ?> newMetaData) {
        this.identifier = identifier;
        this.commandName = commandName;
        this.payload = payload;
        this.metaData = MetaData.from(newMetaData);
    }

    protected GenericCommandMessage(GenericCommandMessage<T> original, Map<String, ?> metaData) {
        this.identifier = original.getIdentifier();
        this.commandName = original.getCommandName();
        this.payload = original.getPayload();
        this.metaData = MetaData.from(metaData);
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public Class getPayloadType() {
        return this.payload.getClass();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public GenericCommandMessage<T> withMetaData(Map<String, ?> newMetaData) {
        if (this.getMetaData().equals(newMetaData)) {
            return this;
        }
        return new GenericCommandMessage<T>(this, newMetaData);
    }

    @Override
    public GenericCommandMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
        if (additionalMetaData.isEmpty()) {
            return this;
        }
        return new GenericCommandMessage<T>(this, (Map<String, ?>)this.metaData.mergedWith(additionalMetaData));
    }
}

