/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.common.Assert;

public class AsynchronousCommandBus
extends SimpleCommandBus {
    private final Executor executor;

    public AsynchronousCommandBus() {
        this(Executors.newCachedThreadPool());
    }

    public AsynchronousCommandBus(Executor executor) {
        Assert.notNull(executor, "executor may not be null");
        this.executor = executor;
    }

    @Override
    protected <R> void doDispatch(CommandMessage<?> command, CommandCallback<R> callback) {
        this.executor.execute(new DispatchCommand<R>(command, callback));
    }

    public void shutdown() {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
            try {
                ((ExecutorService)this.executor).awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final class DispatchCommand<R>
    implements Runnable {
        private final CommandMessage<?> command;
        private final CommandCallback<R> callback;

        public DispatchCommand(CommandMessage<?> command, CommandCallback<R> callback) {
            this.command = command;
            this.callback = callback;
        }

        @Override
        public void run() {
            AsynchronousCommandBus.super.doDispatch(this.command, this.callback);
        }
    }
}

