/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.cache;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.axonframework.cache.AbstractCacheAdapter;
import org.axonframework.cache.Cache;

public class JCacheAdapter
extends AbstractCacheAdapter<CacheEntryListenerConfiguration> {
    private final Cache jCache;

    public JCacheAdapter(Cache jCache) {
        this.jCache = jCache;
    }

    @Override
    public <K, V> V get(K key) {
        return (V)this.jCache.get(key);
    }

    @Override
    public <K, V> void put(K key, V value) {
        this.jCache.put(key, value);
    }

    @Override
    public <K, V> boolean putIfAbsent(K key, V value) {
        return this.jCache.putIfAbsent(key, value);
    }

    @Override
    public <K> boolean remove(K key) {
        return this.jCache.remove(key);
    }

    @Override
    public <K> boolean containsKey(K key) {
        return this.jCache.containsKey(key);
    }

    @Override
    protected CacheEntryListenerConfiguration createListenerAdapter(Cache.EntryListener cacheEntryListener) {
        return new JCacheListenerAdapter(cacheEntryListener);
    }

    @Override
    protected void doUnregisterListener(CacheEntryListenerConfiguration listenerAdapter) {
        this.jCache.deregisterCacheEntryListener(listenerAdapter);
    }

    @Override
    protected void doRegisterListener(CacheEntryListenerConfiguration listenerAdapter) {
        this.jCache.registerCacheEntryListener(listenerAdapter);
    }

    private static final class JCacheListenerAdapter<K, V>
    implements CacheEntryListenerConfiguration<K, V>,
    CacheEntryUpdatedListener<K, V>,
    CacheEntryCreatedListener<K, V>,
    CacheEntryExpiredListener<K, V>,
    CacheEntryRemovedListener<K, V>,
    Factory<CacheEntryListener<? super K, ? super V>>,
    Serializable {
        private static final long serialVersionUID = 3260575514029378445L;
        private final Cache.EntryListener delegate;

        public JCacheListenerAdapter(Cache.EntryListener delegate) {
            this.delegate = delegate;
        }

        public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
                this.delegate.onEntryCreated(cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryExpired(cacheEntryEvent.getKey());
            }
        }

        public Factory<CacheEntryListener<? super K, ? super V>> getCacheEntryListenerFactory() {
            return this;
        }

        public boolean isOldValueRequired() {
            return false;
        }

        public Factory<CacheEntryEventFilter<? super K, ? super V>> getCacheEntryEventFilterFactory() {
            return null;
        }

        public boolean isSynchronous() {
            return true;
        }

        public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryRemoved(cacheEntryEvent.getKey());
            }
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryUpdated(cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }

        public CacheEntryListener create() {
            return this;
        }
    }
}

