/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.auditing;

import org.axonframework.auditing.AuditDataProvider;
import org.axonframework.auditing.AuditLogger;
import org.axonframework.auditing.AuditingUnitOfWorkListener;
import org.axonframework.auditing.EmptyDataProvider;
import org.axonframework.auditing.NullAuditLogger;
import org.axonframework.commandhandling.CommandHandlerInterceptor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.InterceptorChain;
import org.axonframework.unitofwork.UnitOfWork;

public class AuditingInterceptor
implements CommandHandlerInterceptor {
    private AuditDataProvider auditDataProvider = EmptyDataProvider.INSTANCE;
    private AuditLogger auditLogger = NullAuditLogger.INSTANCE;

    @Override
    public Object handle(CommandMessage<?> command, UnitOfWork unitOfWork, InterceptorChain chain) throws Throwable {
        AuditingUnitOfWorkListener auditListener = new AuditingUnitOfWorkListener(command, this.auditDataProvider, this.auditLogger);
        unitOfWork.registerListener(auditListener);
        Object returnValue = chain.proceed();
        auditListener.setReturnValue(returnValue);
        return returnValue;
    }

    public void setAuditDataProvider(AuditDataProvider auditDataProvider) {
        this.auditDataProvider = auditDataProvider;
    }

    public void setAuditLogger(AuditLogger auditLogger) {
        this.auditLogger = auditLogger;
    }
}

