/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.util;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;

public final class OidUtils {
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;

    private OidUtils() {
    }

    public static String getDomainType(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        if (oid == null || !(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.getObjectSpecId().asString();
    }

    public static String getInstanceId(ObjectAdapter objectAdapter) {
        String oidStr = OidUtils.getOidStr(objectAdapter);
        return oidStr != null ? OID_MARSHALLER.splitInstanceId(oidStr) : null;
    }

    public static String getOidStr(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        if (!(oid instanceof RootOid)) {
            throw new IllegalArgumentException("objectAdapter must be a root adapter");
        }
        return oid.enStringNoVersion();
    }
}

