/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.util;

import java.io.IOException;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;

public final class JsonWriterUtil {
    private JsonWriterUtil() {
    }

    public static String jsonFor(Object object) {
        DeploymentCategory deploymentCategory = JsonWriterUtil.getIsisSessionFactory().getDeploymentCategory();
        JsonMapper.PrettyPrinting prettyPrinting = JsonWriterUtil.inferPrettyPrinting(deploymentCategory);
        try {
            return JsonMapper.instance((JsonMapper.PrettyPrinting)prettyPrinting).write(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    private static JsonMapper.PrettyPrinting inferPrettyPrinting(DeploymentCategory deploymentCategory) {
        return deploymentCategory.isProduction() ? JsonMapper.PrettyPrinting.DISABLE : JsonMapper.PrettyPrinting.ENABLE;
    }
}

