/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.Marshaller;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceXRoDomainType;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.PrettyPrinting;
import org.jboss.resteasy.annotations.DecorateTypes;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;

@DecorateTypes(value={"text/*+xml", "application/*+xml"})
public class IsisPrettyPrintingProcessor
implements DecoratorProcessor<Marshaller, PrettyPrinting> {
    public static final String KEY_PRETTY_PRINT = "isis.services." + ContentNegotiationServiceXRoDomainType.class.getSimpleName() + ".prettyPrint";

    public Marshaller decorate(Marshaller target, PrettyPrinting annotation, Class type, Annotation[] annotations, MediaType mediaType) {
        return this.shouldPrettyPrint() ? this.doDecorate(target, annotation, type, annotations, mediaType) : target;
    }

    protected boolean shouldPrettyPrint() {
        try {
            DeploymentCategory deploymentCategory = this.getDeploymentCategory();
            return this.getConfiguration().getBoolean(KEY_PRETTY_PRINT, !deploymentCategory.isProduction());
        }
        catch (Exception e) {
            return true;
        }
    }

    protected Marshaller doDecorate(Marshaller target, PrettyPrinting annotation, Class type, Annotation[] annotations, MediaType mediaType) {
        try {
            target.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            return target;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.getIsisSessionFactory().getDeploymentCategory();
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }

    IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }
}

