/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.rendering.RestfulObjectsApplicationException;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conmap.ContentMappingService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483627")
public class ContentNegotiationServiceXRoDomainType
extends ContentNegotiationServiceAbstract {
    public static final String X_RO_DOMAIN_TYPE = "x-ro-domain-type";
    @Inject
    List<org.apache.isis.applib.conmap.ContentMappingService> contentMappingServices;
    @Inject
    List<ContentMappingService> legacyContentMappingServices;

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAdapter objectAdapter) {
        Object domainObject = this.objectOf(objectAdapter);
        RepresentationType representationType = RepresentationType.DOMAIN_OBJECT;
        MediaType mediaType = this.mediaTypeFrom(renderContext2, representationType);
        if (mediaType == null) {
            return null;
        }
        return this.buildResponse(renderContext2, domainObject, representationType);
    }

    protected MediaType mediaTypeFrom(RepresentationService.Context2 renderContext2, RepresentationType representationType) {
        List<MediaType> acceptableMediaTypes = renderContext2.getAcceptableMediaTypes();
        MediaType mediaType = representationType.matchesXmlProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        if (mediaType == null) {
            mediaType = representationType.matchesJsonProfileWithParameter(acceptableMediaTypes, X_RO_DOMAIN_TYPE);
        }
        return mediaType;
    }

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, ObjectAndActionInvocation objectAndActionInvocation) {
        RepresentationType representationType = RepresentationType.ACTION_RESULT;
        MediaType mediaType = this.mediaTypeFrom(renderContext2, representationType);
        if (mediaType == null) {
            return null;
        }
        Object domainObject = this.returnedObjectOf(objectAndActionInvocation);
        if (domainObject == null) {
            throw RestfulObjectsApplicationException.create(RestfulResponse.HttpStatusCode.NOT_FOUND);
        }
        return this.buildResponse(renderContext2, domainObject, representationType);
    }

    protected Response.ResponseBuilder buildResponse(RepresentationService.Context2 renderContext2, Object domainObject, RepresentationType representationType) {
        List<MediaType> acceptableMediaTypes = renderContext2.getAcceptableMediaTypes();
        MediaType mediaType = this.mediaTypeFrom(renderContext2, representationType);
        if (mediaType == null) {
            return null;
        }
        String xRoDomainType = (String)mediaType.getParameters().get(X_RO_DOMAIN_TYPE);
        Class<?> domainType = this.loadClass(xRoDomainType);
        Object mappedDomainObject = this.map(domainObject, acceptableMediaTypes, representationType);
        this.ensureDomainObjectAssignable(xRoDomainType, domainType, mappedDomainObject);
        if ("xml".equals(mediaType.getSubtype())) {
            this.ensureJaxbAnnotated(mappedDomainObject.getClass());
        }
        return Response.ok((Object)mappedDomainObject, (MediaType)mediaType);
    }

    protected Object map(Object domainObject, List<MediaType> acceptableMediaTypes, RepresentationType representationType) {
        Object mappedObject;
        for (org.apache.isis.applib.conmap.ContentMappingService contentMappingService : this.contentMappingServices) {
            mappedObject = contentMappingService.map(domainObject, acceptableMediaTypes);
            if (mappedObject == null) continue;
            return mappedObject;
        }
        for (ContentMappingService contentMappingService : this.legacyContentMappingServices) {
            mappedObject = contentMappingService.map(domainObject, acceptableMediaTypes, representationType);
            if (mappedObject == null) continue;
            return mappedObject;
        }
        return domainObject;
    }
}

