/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.conneg;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationServiceForRestfulObjectsV1_0;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483637")
public class ContentNegotiationServiceOrgApacheIsisV1
extends ContentNegotiationServiceAbstract {
    public static final String ACCEPT_PROFILE = "urn:org.apache.isis/v1";
    public static final String ACCEPT_RO = "suppress";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object\"";
    public static final String CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"object-collection\"";
    public static final String CONTENT_TYPE_OAI_V1_LIST = "application/json;profile=\"urn:org.apache.isis/v1\";repr-type=\"list\"";
    private ContentNegotiationServiceForRestfulObjectsV1_0 restfulObjectsV1_0 = new ContentNegotiationServiceForRestfulObjectsV1_0();
    @Inject
    protected DomainObjectContainer container;

    @Override
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 rendererContext, ObjectAdapter objectAdapter) {
        JsonRepresentation $$roRepresentation;
        boolean canAccept = this.canAccept(rendererContext);
        if (!canAccept) {
            return null;
        }
        boolean suppressRO = this.suppress(rendererContext);
        JsonRepresentation rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
        this.appendObjectTo(rendererContext, objectAdapter, rootRepresentation);
        if (!suppressRO) {
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAdapter, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 rendererContext, ObjectAndProperty objectAndProperty) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 rendererContext, ObjectAndCollection objectAndCollection) {
        JsonRepresentation $$roRepresentation;
        if (!this.canAccept(rendererContext)) {
            return null;
        }
        boolean suppressRO = this.suppress(rendererContext);
        JsonRepresentation rootRepresentation = JsonRepresentation.newArray();
        ObjectAdapter objectAdapter = objectAndCollection.getObjectAdapter();
        OneToManyAssociation collection = (OneToManyAssociation)objectAndCollection.getMember();
        this.appendCollectionTo(rendererContext, objectAdapter, collection, rootRepresentation);
        if (!suppressRO) {
            JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            rootRepresentation.arrayAdd($$roContainerRepresentation);
            $$roRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
        } else {
            $$roRepresentation = null;
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAndCollection, $$roRepresentation, rootRepresentation);
        responseBuilder.type(CONTENT_TYPE_OAI_V1_OBJECT_COLLECTION);
        return this.responseBuilder(responseBuilder);
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 rendererContext, ObjectAndAction objectAndAction) {
        return null;
    }

    @Override
    @Programmatic
    public Response.ResponseBuilder buildResponse(RepresentationService.Context2 rendererContext, ObjectAndActionInvocation objectAndActionInvocation) {
        if (!this.canAccept(rendererContext)) {
            return null;
        }
        boolean suppressRO = this.suppress(rendererContext);
        JsonRepresentation rootRepresentation = null;
        JsonRepresentation $$roRepresentation = !suppressRO ? JsonRepresentation.newMap((String[])new String[0]) : null;
        ObjectAdapter returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        ObjectSpecification returnType = objectAndActionInvocation.getAction().getReturnType();
        if (returnedAdapter == null) {
            return null;
        }
        ActionResultRepresentation.ResultType resultType = objectAndActionInvocation.determineResultType();
        switch (resultType) {
            case DOMAIN_OBJECT: {
                rootRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                this.appendObjectTo(rendererContext, returnedAdapter, rootRepresentation);
                break;
            }
            case LIST: {
                rootRepresentation = JsonRepresentation.newArray();
                CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
                Collection collectionAdapters = collectionFacet.collection(returnedAdapter);
                this.appendIterableTo(rendererContext, collectionAdapters, rootRepresentation);
                if (suppressRO) break;
                JsonRepresentation $$roContainerRepresentation = JsonRepresentation.newMap((String[])new String[0]);
                rootRepresentation.arrayAdd($$roContainerRepresentation);
                $$roContainerRepresentation.mapPut("$$ro", $$roRepresentation);
                break;
            }
            case SCALAR_VALUE: 
            case VOID: {
                return null;
            }
        }
        Response.ResponseBuilder responseBuilder = this.restfulObjectsV1_0.buildResponseTo(rendererContext, objectAndActionInvocation, $$roRepresentation, rootRepresentation);
        responseBuilder.type(resultType == ActionResultRepresentation.ResultType.DOMAIN_OBJECT ? CONTENT_TYPE_OAI_V1_OBJECT : CONTENT_TYPE_OAI_V1_LIST);
        return this.responseBuilder(responseBuilder);
    }

    protected Response.ResponseBuilder responseBuilder(Response.ResponseBuilder responseBuilder) {
        return responseBuilder;
    }

    boolean canAccept(RepresentationService.Context2 rendererContext) {
        List<MediaType> acceptableMediaTypes = rendererContext.getAcceptableMediaTypes();
        return this.mediaTypeParameterMatches(acceptableMediaTypes, "profile", ACCEPT_PROFILE);
    }

    protected boolean suppress(RepresentationService.Context2 rendererContext) {
        List<MediaType> acceptableMediaTypes = rendererContext.getAcceptableMediaTypes();
        return this.mediaTypeParameterMatches(acceptableMediaTypes, ACCEPT_RO, "true");
    }

    private void appendObjectTo(RepresentationService.Context2 rendererContext, ObjectAdapter objectAdapter, JsonRepresentation rootRepresentation) {
        this.appendPropertiesTo(rendererContext, objectAdapter, rootRepresentation);
        List collections = objectAdapter.getSpecification().getCollections(Contributed.INCLUDED);
        Where where = rendererContext.getWhere();
        for (OneToManyAssociation collection : collections) {
            JsonRepresentation collectionRepresentation = JsonRepresentation.newArray();
            rootRepresentation.mapPut(collection.getId(), collectionRepresentation);
            InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
            Consent visibility = collection.isVisible(objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) continue;
            this.appendCollectionTo(rendererContext, objectAdapter, collection, collectionRepresentation);
        }
    }

    private void appendPropertiesTo(RepresentationService.Context2 rendererContext, ObjectAdapter objectAdapter, JsonRepresentation rootRepresentation) {
        InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
        Where where = rendererContext.getWhere();
        List properties = objectAdapter.getSpecification().getProperties(Contributed.INCLUDED);
        for (OneToOneAssociation property : properties) {
            Consent visibility = property.isVisible(objectAdapter, interactionInitiatedBy, where);
            if (!visibility.isAllowed()) continue;
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectPropertyReprRenderer renderer = (ObjectPropertyReprRenderer)new ObjectPropertyReprRenderer((RendererContext)rendererContext, null, property.getId(), propertyRepresentation).asStandalone();
            renderer.with(new ObjectAndProperty(objectAdapter, property));
            JsonRepresentation propertyValueRepresentation = renderer.render();
            String upHref = propertyValueRepresentation.getString("links[rel=up].href");
            rootRepresentation.mapPut("$$href", upHref);
            String upTitle = propertyValueRepresentation.getString("links[rel=up].title");
            rootRepresentation.mapPut("$$title", upTitle);
            String upInstanceId = upHref.substring(upHref.lastIndexOf("/") + 1);
            rootRepresentation.mapPut("$$instanceId", upInstanceId);
            JsonRepresentation value = propertyValueRepresentation.getRepresentation("value", new Object[0]);
            rootRepresentation.mapPut(property.getId(), value);
        }
    }

    private void appendCollectionTo(RepresentationService.Context2 rendererContext, ObjectAdapter objectAdapter, OneToManyAssociation collection, JsonRepresentation representation) {
        InteractionInitiatedBy interactionInitiatedBy = ContentNegotiationServiceOrgApacheIsisV1.determineInteractionInitiatedByFrom(rendererContext);
        ObjectAdapter valueAdapter = collection.get(objectAdapter, interactionInitiatedBy);
        if (valueAdapter == null) {
            return;
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)valueAdapter);
        Iterable iterable = facet.iterable(valueAdapter);
        this.appendIterableTo(rendererContext, iterable, representation);
    }

    private void appendIterableTo(RepresentationService.Context2 rendererContext, Iterable<ObjectAdapter> iterable, JsonRepresentation collectionRepresentation) {
        for (ObjectAdapter elementAdapter : iterable) {
            JsonRepresentation elementRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            this.appendPropertiesTo(rendererContext, elementAdapter, elementRepresentation);
            collectionRepresentation.arrayAdd(elementRepresentation);
        }
    }

    private static InteractionInitiatedBy determineInteractionInitiatedByFrom(RendererContext rendererContext) {
        if (rendererContext instanceof RepresentationService.Context4) {
            return ((RepresentationService.Context4)rendererContext).getInteractionInitiatedBy();
        }
        return InteractionInitiatedBy.USER;
    }
}

