/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service.acceptheader;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.acceptheader.AcceptHeaderService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class AcceptHeaderServiceForRest
implements AcceptHeaderService {
    private static ThreadLocal<List<MediaType>> mediaTypesByThread = new ThreadLocal();

    private static void setMediaTypes(List<MediaType> mediaTypes) {
        mediaTypesByThread.set(mediaTypes);
    }

    private static void removeMediaTypes() {
        mediaTypesByThread.remove();
    }

    @Programmatic
    public List<MediaType> getAcceptableMediaTypes() {
        return mediaTypesByThread.get();
    }

    @Provider
    public static class ResponseFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            AcceptHeaderServiceForRest.removeMediaTypes();
        }
    }

    @Provider
    public static class RequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            List acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
            ArrayList mediaTypes = Lists.newArrayList((Iterable)Lists.transform((List)acceptableMediaTypes, (Function)new Function<javax.ws.rs.core.MediaType, MediaType>(){

                @Nullable
                public MediaType apply(@Nullable javax.ws.rs.core.MediaType input) {
                    if (input == null) {
                        return null;
                    }
                    MediaType mediaType = MediaType.create((String)input.getType(), (String)input.getSubtype());
                    SetMultimap parameters = Multimaps.forMap((Map)input.getParameters());
                    return mediaType.withParameters((Multimap)parameters);
                }
            }));
            AcceptHeaderServiceForRest.setMediaTypes(mediaTypes);
        }
    }
}

