/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.service;

import com.google.common.base.Function;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberReprMode;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.service.RepresentationService;
import org.apache.isis.viewer.restfulobjects.rendering.service.conneg.ContentNegotiationService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class RepresentationServiceContentNegotiator
implements RepresentationService {
    @Inject
    List<ContentNegotiationService> contentNegotiationServices;

    @PostConstruct
    public void init(Map<String, String> properties) {
    }

    @Override
    @Programmatic
    public Response objectRepresentation(RepresentationService.Context rendererContext, final ObjectAdapter objectAdapter) {
        final RepresentationService.Context2 renderContext2 = this.asContext2(rendererContext);
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext2, objectAdapter);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Deprecated
    @Programmatic
    public Response objectRepresentation(RepresentationService.Context rendererContext, ObjectAdapter objectAdapter, RepresentationService.Intent unused) {
        return this.objectRepresentation(rendererContext, objectAdapter);
    }

    @Override
    @Programmatic
    public Response propertyDetails(RepresentationService.Context rendererContext, final ObjectAndProperty objectAndProperty, MemberReprMode memberReprMode) {
        final RepresentationService.Context2 renderContext2 = this.asContext2(rendererContext);
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext2, objectAndProperty);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response collectionDetails(RepresentationService.Context rendererContext, final ObjectAndCollection objectAndCollection, MemberReprMode memberReprMode) {
        final RepresentationService.Context2 renderContext2 = this.asContext2(rendererContext);
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext2, objectAndCollection);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionPrompt(RepresentationService.Context rendererContext, final ObjectAndAction objectAndAction) {
        final RepresentationService.Context2 renderContext2 = this.asContext2(rendererContext);
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext2, objectAndAction);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    @Override
    @Programmatic
    public Response actionResult(RepresentationService.Context rendererContext, final ObjectAndActionInvocation objectAndActionInvocation, ActionResultReprRenderer.SelfLink selfLink) {
        final RepresentationService.Context2 renderContext2 = this.asContext2(rendererContext);
        Response.ResponseBuilder responseBuilder = this.buildResponse(new Function<ContentNegotiationService, Response.ResponseBuilder>(){

            public Response.ResponseBuilder apply(ContentNegotiationService connegService) {
                return connegService.buildResponse(renderContext2, objectAndActionInvocation);
            }
        });
        this.assertContentNegotiationServiceHandled(responseBuilder);
        return this.buildResponse(responseBuilder);
    }

    private RepresentationService.Context2 asContext2(RepresentationService.Context rendererContext) {
        if (rendererContext instanceof RepresentationService.Context2) {
            RepresentationService.Context2 context = (RepresentationService.Context2)rendererContext;
            return context;
        }
        throw new IllegalArgumentException(String.format("The %s requires that the context to implement %s", RepresentationServiceContentNegotiator.class.getSimpleName(), RepresentationService.Context2.class.getName()));
    }

    void assertContentNegotiationServiceHandled(Response.ResponseBuilder responseBuilder) {
        if (responseBuilder == null) {
            throw new IllegalStateException("Could not locate " + ContentNegotiationService.class.getSimpleName() + " to handle request");
        }
    }

    Response.ResponseBuilder buildResponse(Function<ContentNegotiationService, Response.ResponseBuilder> connegServiceBuildResponse) {
        for (ContentNegotiationService contentNegotiationService : this.contentNegotiationServices) {
            Response.ResponseBuilder responseBuilder = (Response.ResponseBuilder)connegServiceBuildResponse.apply((Object)contentNegotiationService);
            if (responseBuilder == null) continue;
            return responseBuilder;
        }
        return null;
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.build();
    }
}

