/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.facets.value.biginteger.BigIntegerValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.PropertyDescriptionReprRenderer;

public class ObjectPropertyReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectPropertyReprRenderer, OneToOneAssociation> {
    public ObjectPropertyReprRenderer(RendererContext resourceContext) {
        this(resourceContext, (LinkFollowSpecs)null, (String)null, JsonRepresentation.newMap((String[])new String[0]));
    }

    public ObjectPropertyReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, String propertyId, JsonRepresentation representation) {
        super(resourceContext, linkFollower, propertyId, RepresentationType.OBJECT_PROPERTY, representation, Where.OBJECT_FORMS);
    }

    @Override
    public JsonRepresentation render() {
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        this.addValue(followValue);
        this.putDisabledReasonIfDisabled();
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addChoices();
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private Object addValue(LinkFollowSpecs linkFollower) {
        boolean eagerlyRender;
        ObjectAdapter valueAdapter = ((OneToOneAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        ObjectSpecification spec = valueAdapter != null ? valueAdapter.getSpecification() : ((OneToOneAssociation)this.objectMember).getSpecification();
        ValueFacet valueFacet = (ValueFacet)spec.getFacet(ValueFacet.class);
        if (valueFacet != null) {
            BigIntegerValueFacet bigIntegerValueFacet;
            String format = null;
            Class specClass = spec.getCorrespondingClass();
            if (specClass == BigDecimal.class) {
                BigDecimalValueFacet bigDecimalValueFacet = ObjectPropertyReprRenderer.getFacet(BigDecimalValueFacet.class, new FacetHolder[]{this.objectMember, valueAdapter != null ? valueAdapter.getSpecification() : null});
                if (bigDecimalValueFacet != null) {
                    Integer precision = bigDecimalValueFacet.getPrecision();
                    Integer scale = bigDecimalValueFacet.getScale();
                    format = String.format("big-decimal(%d,%d)", precision, scale);
                }
            } else if (specClass == BigInteger.class && (bigIntegerValueFacet = ObjectPropertyReprRenderer.getFacet(BigIntegerValueFacet.class, new FacetHolder[]{this.objectMember, valueAdapter != null ? valueAdapter.getSpecification() : null})) != null) {
                format = String.format("big-integer", new Object[0]);
            }
            return JsonValueEncoder.appendValueAndFormat(spec, valueAdapter, this.representation, format, this.rendererContext.suppressMemberExtensions());
        }
        RenderFacet renderFacet = (RenderFacet)((OneToOneAssociation)this.objectMember).getFacet(RenderFacet.class);
        boolean bl = eagerlyRender = renderFacet != null && renderFacet.value() == Render.Type.EAGERLY && this.rendererContext.canEagerlyRender(valueAdapter) || linkFollower != null && !linkFollower.isTerminated();
        if (valueAdapter == null) {
            NullNode value = NullNode.getInstance();
            this.representation.mapPut("value", (JsonNode)value);
            return value;
        }
        TitleFacet titleFacet = (TitleFacet)spec.getFacet(TitleFacet.class);
        String title = titleFacet.title(valueAdapter);
        LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.rendererContext, Rel.VALUE, valueAdapter).withTitle(title);
        if (eagerlyRender) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.rendererContext, linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(valueAdapter);
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            valueLinkBuilder.withValue(renderer.render());
        }
        JsonRepresentation valueJsonRepr = valueLinkBuilder.build();
        this.representation.mapPut("value", valueJsonRepr);
        return valueJsonRepr;
    }

    private static <T extends Facet> T getFacet(Class<T> facetType, FacetHolder ... holders) {
        for (FacetHolder holder : holders) {
            Facet facet;
            if (holder == null || (facet = holder.getFacet(facetType)) == null) continue;
            return (T)facet;
        }
        return null;
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
        ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getRendererContext(), this.getLinkFollowSpecs(), null, representation);
        ((ObjectPropertyReprRenderer)renderer.with(new ObjectAndProperty(this.objectAdapter, (OneToOneAssociation)this.objectMember))).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        for (String mutator : mutators.keySet()) {
            MutatorSpec mutatorSpec = mutators.get(mutator);
            this.addLinkFor(mutatorSpec);
        }
    }

    private ObjectPropertyReprRenderer addChoices() {
        Object propertyChoices = this.propertyChoices();
        if (propertyChoices != null) {
            this.representation.mapPut("choices", propertyChoices);
        }
        return this;
    }

    private Object propertyChoices() {
        ObjectAdapter[] choiceAdapters = ((OneToOneAssociation)this.objectMember).getChoices(this.objectAdapter, this.getInteractionInitiatedBy());
        if (choiceAdapters == null || choiceAdapters.length == 0) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (ObjectAdapter choiceAdapter : choiceAdapters) {
            ObjectSpecification choiceSpec = choiceAdapter.getSpecification();
            list.add(DomainObjectReprRenderer.valueOrRef(this.rendererContext, choiceAdapter, choiceSpec));
        }
        return list;
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.rendererContext.suppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = PropertyDescriptionReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToOneAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void addLinksIsisProprietary() {
    }

    @Override
    protected void putExtensionsIsisProprietary() {
    }
}

