/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.AbstractObjectMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.CollectionSemantics;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.CollectionDescriptionReprRenderer;

public class ObjectCollectionReprRenderer
extends AbstractObjectMemberReprRenderer<ObjectCollectionReprRenderer, OneToManyAssociation> {
    public ObjectCollectionReprRenderer(RendererContext rendererContext, LinkFollowSpecs linkFollowSpecs, String collectionId, JsonRepresentation representation) {
        super(rendererContext, linkFollowSpecs, collectionId, RepresentationType.OBJECT_COLLECTION, representation, Where.PARENTED_TABLES);
    }

    @Override
    public JsonRepresentation render() {
        boolean eagerlyRender;
        if (this.representation == null) {
            return null;
        }
        this.renderMemberContent();
        LinkFollowSpecs followValue = this.getLinkFollowSpecs().follow("value", new Object[0]);
        boolean bl = eagerlyRender = this.rendererContext.honorUiHints() && this.renderEagerly() || !followValue.isTerminated();
        if (this.mode.isInline() && eagerlyRender || this.mode.isStandalone() || this.mode.isMutated() || this.mode.isEventSerialization() || !this.objectAdapter.representsPersistent()) {
            this.addValue(followValue);
        }
        if (!this.mode.isEventSerialization()) {
            this.putDisabledReasonIfDisabled();
        }
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addExtensionsIsisProprietaryChangedObjects();
        }
        return this.representation;
    }

    private boolean renderEagerly() {
        RenderFacet renderFacet = (RenderFacet)((OneToManyAssociation)this.objectMember).getFacet(RenderFacet.class);
        return renderFacet != null && renderFacet.value() == Render.Type.EAGERLY;
    }

    private void addValue(LinkFollowSpecs linkFollower) {
        ObjectAdapter valueAdapter = ((OneToManyAssociation)this.objectMember).get(this.objectAdapter, this.getInteractionInitiatedBy());
        if (valueAdapter == null) {
            return;
        }
        LinkFollowSpecs followHref = linkFollower.follow("href", new Object[0]);
        boolean eagerlyRender = this.rendererContext.honorUiHints() && this.renderEagerly(valueAdapter) || !followHref.isTerminated();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)valueAdapter);
        ArrayList list = Lists.newArrayList();
        for (ObjectAdapter elementAdapter : facet.iterable(valueAdapter)) {
            LinkBuilder valueLinkBuilder = DomainObjectReprRenderer.newLinkToBuilder(this.rendererContext, Rel.VALUE, elementAdapter);
            if (eagerlyRender) {
                DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getRendererContext(), followHref, JsonRepresentation.newMap((String[])new String[0]));
                renderer.with(elementAdapter);
                if (this.mode.isEventSerialization()) {
                    renderer.asEventSerialization();
                }
                valueLinkBuilder.withValue(renderer.render());
            }
            list.add(valueLinkBuilder.build());
        }
        this.representation.mapPut("value", (Object)list);
    }

    private boolean renderEagerly(ObjectAdapter valueAdapter) {
        RenderFacet renderFacet = (RenderFacet)((OneToManyAssociation)this.objectMember).getFacet(RenderFacet.class);
        return renderFacet != null && renderFacet.value() == Render.Type.EAGERLY && this.rendererContext.canEagerlyRender(valueAdapter);
    }

    @Override
    protected void followDetailsLink(JsonRepresentation detailsLink) {
        JsonRepresentation representation = JsonRepresentation.newMap((String[])new String[0]);
        ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(this.getRendererContext(), this.getLinkFollowSpecs(), null, representation);
        ((ObjectCollectionReprRenderer)renderer.with(new ObjectAndCollection(this.objectAdapter, (OneToManyAssociation)this.objectMember))).asFollowed();
        detailsLink.mapPut("value", renderer.render());
    }

    @Override
    protected void addMutatorLinksIfEnabled() {
        if (this.usability().isVetoed()) {
            return;
        }
        CollectionSemantics semantics = CollectionSemantics.determine((OneToManyAssociation)this.objectMember);
        this.addMutatorLink(semantics.getAddToKey());
        this.addMutatorLink(semantics.getRemoveFromKey());
    }

    private void addMutatorLink(String key) {
        Map<String, MutatorSpec> mutators = this.objectMemberType.getMutators();
        MutatorSpec mutatorSpec = mutators.get(key);
        this.addLinkFor(mutatorSpec);
    }

    @Override
    protected void addLinksToFormalDomainModel() {
        if (this.rendererContext.suppressDescribedByLinks()) {
            return;
        }
        JsonRepresentation link = CollectionDescriptionReprRenderer.newLinkToBuilder(this.rendererContext, Rel.DESCRIBEDBY, this.objectAdapter.getSpecification(), (OneToManyAssociation)this.objectMember).build();
        this.getLinks().arrayAdd(link);
    }

    @Override
    protected void addLinksIsisProprietary() {
    }

    @Override
    protected void putExtensionsIsisProprietary() {
        CollectionSemantics semantics = CollectionSemantics.determine((OneToManyAssociation)this.objectMember);
        this.getExtensions().mapPut("collectionSemantics", semantics.name().toLowerCase());
    }
}

