/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ActionResultReprRenderer;

public class ObjectAndActionInvocation {
    private final ObjectAdapter objectAdapter;
    private final ObjectAction action;
    private final JsonRepresentation arguments;
    private final List<ObjectAdapter> argAdapters;
    private final ObjectAdapter returnedAdapter;
    private final ActionResultReprRenderer.SelfLink selfLink;

    public ObjectAndActionInvocation(ObjectAdapter objectAdapter, ObjectAction action, JsonRepresentation arguments, List<ObjectAdapter> argAdapters, ObjectAdapter returnedAdapter, ActionResultReprRenderer.SelfLink selfLink) {
        this.objectAdapter = objectAdapter;
        this.action = action;
        this.arguments = arguments;
        this.argAdapters = argAdapters;
        this.returnedAdapter = returnedAdapter;
        this.selfLink = selfLink;
    }

    public ObjectAdapter getObjectAdapter() {
        return this.objectAdapter;
    }

    public ObjectAction getAction() {
        return this.action;
    }

    public JsonRepresentation getArguments() {
        return this.arguments;
    }

    public List<ObjectAdapter> getArgAdapters() {
        return this.argAdapters;
    }

    public ObjectAdapter getReturnedAdapter() {
        return this.returnedAdapter;
    }

    public ActionResultReprRenderer.SelfLink getSelfLink() {
        return this.selfLink;
    }

    public ActionResultRepresentation.ResultType determineResultType() {
        ObjectSpecification returnType = this.action.getReturnType();
        if (returnType.getCorrespondingClass() == Void.TYPE) {
            return ActionResultRepresentation.ResultType.VOID;
        }
        CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
        if (collectionFacet != null) {
            return ActionResultRepresentation.ResultType.LIST;
        }
        EncodableFacet encodableFacet = (EncodableFacet)returnType.getFacet(EncodableFacet.class);
        if (encodableFacet != null) {
            return ActionResultRepresentation.ResultType.SCALAR_VALUE;
        }
        return ActionResultRepresentation.ResultType.DOMAIN_OBJECT;
    }
}

