/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.validate.ActionValidationFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.properties.update.clear.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.update.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.facets.properties.validating.PropertyValidateFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.BodyArgs;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;

public enum MemberType {
    PROPERTY("properties/", RepresentationType.OBJECT_PROPERTY, (Map)ImmutableMap.of((Object)"modify", (Object)MutatorSpec.of(Rel.MODIFY, PropertyValidateFacet.class, PropertySetterFacet.class, RestfulHttpMethod.PUT, BodyArgs.ONE), (Object)"clear", (Object)MutatorSpec.of(Rel.CLEAR, PropertyValidateFacet.class, PropertyClearFacet.class, RestfulHttpMethod.DELETE, BodyArgs.NONE))){

        @Override
        public ObjectSpecification specFor(ObjectMember objectMember) {
            return objectMember.getSpecification();
        }
    }
    ,
    COLLECTION("collections/", RepresentationType.OBJECT_COLLECTION, (Map)ImmutableMap.of((Object)"addToSet", (Object)MutatorSpec.of(Rel.ADD_TO, CollectionValidateAddToFacet.class, CollectionAddToFacet.class, RestfulHttpMethod.PUT, BodyArgs.ONE), (Object)"addToList", (Object)MutatorSpec.of(Rel.ADD_TO, CollectionValidateAddToFacet.class, CollectionAddToFacet.class, RestfulHttpMethod.POST, BodyArgs.ONE), (Object)"removeFrom", (Object)MutatorSpec.of(Rel.REMOVE_FROM, CollectionValidateRemoveFromFacet.class, CollectionRemoveFromFacet.class, RestfulHttpMethod.DELETE, BodyArgs.ONE))){

        @Override
        public ObjectSpecification specFor(ObjectMember objectMember) {
            return objectMember.getSpecification();
        }
    }
    ,
    ACTION("actions/", RepresentationType.OBJECT_ACTION, (Map)ImmutableMap.of((Object)"invokeQueryOnly", (Object)MutatorSpec.of(Rel.INVOKE, ActionValidationFacet.class, ActionInvocationFacet.class, RestfulHttpMethod.GET, BodyArgs.MANY, "invoke"), (Object)"invokeIdempotent", (Object)MutatorSpec.of(Rel.INVOKE, ActionValidationFacet.class, ActionInvocationFacet.class, RestfulHttpMethod.PUT, BodyArgs.MANY, "invoke"), (Object)"invoke", (Object)MutatorSpec.of(Rel.INVOKE, ActionValidationFacet.class, ActionInvocationFacet.class, RestfulHttpMethod.POST, BodyArgs.MANY, "invoke"))){

        @Override
        public ObjectSpecification specFor(ObjectMember objectMember) {
            ObjectAction objectAction = (ObjectAction)objectMember;
            return objectAction.getReturnType();
        }
    };

    private final String urlPart;
    private final String name;
    private final RepresentationType representationType;
    private final Map<String, MutatorSpec> mutators;

    private MemberType(String urlPart, RepresentationType representationType, Map<String, MutatorSpec> mutators) {
        this.urlPart = urlPart;
        this.representationType = representationType;
        this.mutators = mutators;
        this.name = Enums.enumToCamelCase((Enum)this);
    }

    public String getUrlPart() {
        return this.urlPart;
    }

    public Map<String, MutatorSpec> getMutators() {
        return this.mutators;
    }

    public abstract ObjectSpecification specFor(ObjectMember var1);

    public boolean isProperty() {
        return this == PROPERTY;
    }

    public boolean isCollection() {
        return this == COLLECTION;
    }

    public boolean isAction() {
        return this == ACTION;
    }

    public static MemberType lookup(String memberTypeName) {
        for (MemberType memberType : MemberType.values()) {
            if (!memberType.getName().equals(memberTypeName)) continue;
            return memberType;
        }
        return null;
    }

    public static MemberType of(ObjectMember objectMember) {
        return objectMember.isAction() ? ACTION : (objectMember.isOneToOneAssociation() ? PROPERTY : COLLECTION);
    }

    public RepresentationType getRepresentationType() {
        return this.representationType;
    }

    public String getName() {
        return this.name;
    }

    public static MemberType determineFrom(ObjectFeature objectFeature) {
        if (objectFeature instanceof ObjectAction) {
            return ACTION;
        }
        if (objectFeature instanceof OneToOneAssociation) {
            return PROPERTY;
        }
        if (objectFeature instanceof OneToManyAssociation) {
            return COLLECTION;
        }
        return null;
    }
}

