/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.util.List;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.core.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectActionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndAction;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndCollection;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndProperty;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectCollectionReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectPropertyReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.util.OidUtils;

public class DomainObjectReprRenderer
extends ReprRendererAbstract<DomainObjectReprRenderer, ObjectAdapter> {
    private static final String X_RO_DOMAIN_TYPE = "x-ro-domain-type";
    private ObjectAdapterLinkTo linkToBuilder;
    private ObjectAdapter objectAdapter;
    private Mode mode = Mode.REGULAR;

    public static LinkBuilder newLinkToBuilder(RendererContext rendererContext, Rel rel, ObjectAdapter objectAdapter) {
        String domainType = OidUtils.getDomainType(objectAdapter);
        String instanceId = OidUtils.getInstanceId(objectAdapter);
        String url = "objects/" + domainType + "/" + instanceId;
        return LinkBuilder.newBuilder(rendererContext, rel.getName(), RepresentationType.DOMAIN_OBJECT, url, new Object[0]).withTitle(objectAdapter.titleString(null));
    }

    public static LinkBuilder newLinkToObjectLayoutBuilder(RendererContext rendererContext, ObjectAdapter objectAdapter) {
        Rel rel = Rel.OBJECT_LAYOUT;
        String domainType = OidUtils.getDomainType(objectAdapter);
        String instanceId = OidUtils.getInstanceId(objectAdapter);
        String url = "objects/" + domainType + "/" + instanceId + "/object-layout";
        return LinkBuilder.newBuilder(rendererContext, rel.getName(), RepresentationType.OBJECT_LAYOUT, url, new Object[0]);
    }

    public static LinkBuilder newLinkToObjectIconBuilder(RendererContext rendererContext, ObjectAdapter objectAdapter) {
        Rel rel = Rel.OBJECT_ICON;
        String domainType = OidUtils.getDomainType(objectAdapter);
        String instanceId = OidUtils.getInstanceId(objectAdapter);
        String url = "objects/" + domainType + "/" + instanceId + "/image";
        return LinkBuilder.newBuilder(rendererContext, rel.getName(), RepresentationType.OBJECT_IMAGE, url, new Object[0]);
    }

    public DomainObjectReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.DOMAIN_OBJECT, representation);
        this.usingLinkToBuilder(new DomainObjectLinkTo());
    }

    public DomainObjectReprRenderer usingLinkToBuilder(ObjectAdapterLinkTo objectAdapterLinkToBuilder) {
        this.linkToBuilder = objectAdapterLinkToBuilder.usingUrlBase(this.rendererContext);
        return this;
    }

    @Override
    public DomainObjectReprRenderer with(ObjectAdapter objectAdapter) {
        this.objectAdapter = objectAdapter;
        String domainTypeHref = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.DOMAIN_TYPE, objectAdapter.getSpecification()).build().getString("href");
        this.addMediaTypeParams(X_RO_DOMAIN_TYPE, domainTypeHref);
        return this;
    }

    @Override
    public JsonRepresentation render() {
        if (this.representation == null) {
            return null;
        }
        boolean isService = this.objectAdapter.getSpecification().isService();
        if (!this.mode.isArgs()) {
            if (this.objectAdapter.representsPersistent()) {
                if (this.includesSelf) {
                    this.addLinkToSelf();
                }
                this.getExtensions().mapPut("oid", this.getOidStr());
            }
            String title = this.objectAdapter.titleString(null);
            this.representation.mapPut("title", title);
            if (isService) {
                this.representation.mapPut("serviceId", ServiceUtil.id((Object)this.objectAdapter.getObject()));
            } else {
                String domainType = this.getDomainType();
                String instanceId = this.getInstanceId();
                if (domainType != null) {
                    this.representation.mapPut("domainType", domainType);
                    this.representation.mapPut("instanceId", instanceId);
                }
            }
        }
        if (!this.mode.isUpdatePropertiesLinkArgs()) {
            this.withMembers(this.objectAdapter);
        }
        if (this.mode.includeDescribedBy() && !this.rendererContext.suppressDescribedByLinks()) {
            this.addLinkToDescribedBy();
            this.addLinkToObjectLayout();
            this.addLinkToObjectIcon();
        }
        if (isService && this.mode.includeUp()) {
            this.addLinkToUp();
        }
        if (!this.mode.isArgs() && !this.rendererContext.objectPropertyValuesOnly()) {
            DomainServiceLayout.MenuBar menuBar;
            ObjectSpecification objectSpec;
            DomainServiceLayoutFacet layoutFacet;
            this.addPersistLinkIfTransientAndPersistable();
            this.addUpdatePropertiesLinkIfRequired();
            this.getExtensions().mapPut("isService", isService);
            this.getExtensions().mapPut("isPersistent", this.objectAdapter.representsPersistent());
            if (isService && (layoutFacet = (DomainServiceLayoutFacet)(objectSpec = this.objectAdapter.getSpecification()).getFacet(DomainServiceLayoutFacet.class)) != null && (menuBar = layoutFacet.getMenuBar()) != null) {
                this.getExtensions().mapPut("menuBar", (Object)menuBar);
            }
        }
        return this.representation;
    }

    private void addLinkToSelf() {
        JsonRepresentation link = this.linkToBuilder.with(this.objectAdapter).builder(Rel.SELF).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.objectAdapter);
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToDescribedBy() {
        JsonRepresentation link = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.DESCRIBEDBY, this.objectAdapter.getSpecification()).build();
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainTypeReprRenderer renderer = new DomainTypeReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0]));
            renderer.with(this.objectAdapter.getSpecification());
            link.mapPut("value", renderer.render());
        }
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToObjectLayout() {
        LinkBuilder linkBuilder = DomainObjectReprRenderer.newLinkToObjectLayoutBuilder(this.getRendererContext(), this.objectAdapter);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToObjectIcon() {
        LinkBuilder linkBuilder = DomainObjectReprRenderer.newLinkToObjectIconBuilder(this.getRendererContext(), this.objectAdapter);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
    }

    private void addLinkToUp() {
        JsonRepresentation link = LinkBuilder.newBuilder(this.rendererContext, Rel.UP.getName(), RepresentationType.LIST, "services", new Object[0]).build();
        this.getLinks().arrayAdd(link);
    }

    private String getDomainType() {
        return OidUtils.getDomainType(this.objectAdapter);
    }

    private String getInstanceId() {
        return OidUtils.getInstanceId(this.objectAdapter);
    }

    private String getOidStr() {
        return OidUtils.getOidStr(this.objectAdapter);
    }

    private DomainObjectReprRenderer withMembers(ObjectAdapter objectAdapter) {
        JsonRepresentation appendTo = this.mode.isUpdatePropertiesLinkArgs() ? this.representation : JsonRepresentation.newMap((String[])new String[0]);
        List associations = objectAdapter.getSpecification().getAssociations(Contributed.INCLUDED);
        this.addProperties(objectAdapter, appendTo, associations);
        if (!this.rendererContext.objectPropertyValuesOnly()) {
            if (!this.mode.isArgs()) {
                this.addCollections(objectAdapter, appendTo, associations);
            }
            if (this.mode.isRegular()) {
                List actions = objectAdapter.getSpecification().getObjectActions(Contributed.INCLUDED);
                this.addActions(objectAdapter, actions, appendTo);
            }
        }
        if (!this.mode.isUpdatePropertiesLinkArgs()) {
            this.representation.mapPut("members", appendTo);
        }
        return this;
    }

    private void addProperties(ObjectAdapter objectAdapter, JsonRepresentation members, List<ObjectAssociation> associations) {
        for (ObjectAssociation assoc : associations) {
            Consent visibility;
            if (this.mode.checkVisibility() && !(visibility = assoc.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.rendererContext.getWhere())).isAllowed() || !(assoc instanceof OneToOneAssociation)) continue;
            OneToOneAssociation property = (OneToOneAssociation)assoc;
            LinkFollowSpecs linkFollowerForProp = this.getLinkFollowSpecs().follow("members[" + property.getId() + "]", new Object[0]);
            JsonRepresentation propertyRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectPropertyReprRenderer renderer = new ObjectPropertyReprRenderer(this.getRendererContext(), linkFollowerForProp, property.getId(), propertyRepresentation);
            ((ObjectPropertyReprRenderer)renderer.with(new ObjectAndProperty(objectAdapter, property))).usingLinkTo(this.linkToBuilder);
            if (this.mode.isArgs()) {
                renderer.asArguments();
            }
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            JsonRepresentation propertyValueRepresentation = renderer.render();
            JsonRepresentation propertyRepr = this.rendererContext.objectPropertyValuesOnly() ? propertyValueRepresentation.getRepresentation("value", new Object[0]) : propertyValueRepresentation;
            members.mapPut(assoc.getId(), propertyRepr);
        }
    }

    private void addCollections(ObjectAdapter objectAdapter, JsonRepresentation members, List<ObjectAssociation> associations) {
        for (ObjectAssociation assoc : associations) {
            Consent visibility;
            if (this.mode.checkVisibility() && !(visibility = assoc.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.rendererContext.getWhere())).isAllowed() || !(assoc instanceof OneToManyAssociation)) continue;
            OneToManyAssociation collection = (OneToManyAssociation)assoc;
            LinkFollowSpecs linkFollowerForColl = this.getLinkFollowSpecs().follow("members[" + collection.getId() + "]", new Object[0]);
            JsonRepresentation collectionRepresentation = JsonRepresentation.newMap((String[])new String[0]);
            ObjectCollectionReprRenderer renderer = new ObjectCollectionReprRenderer(this.getRendererContext(), linkFollowerForColl, collection.getId(), collectionRepresentation);
            ((ObjectCollectionReprRenderer)renderer.with(new ObjectAndCollection(objectAdapter, collection))).usingLinkTo(this.linkToBuilder);
            if (this.mode.isEventSerialization()) {
                renderer.asEventSerialization();
            }
            members.mapPut(assoc.getId(), renderer.render());
        }
    }

    private void addActions(ObjectAdapter objectAdapter, List<ObjectAction> actions, JsonRepresentation members) {
        for (ObjectAction action : actions) {
            Consent visibility = action.isVisible(objectAdapter, this.getInteractionInitiatedBy(), this.rendererContext.getWhere());
            if (!visibility.isAllowed()) continue;
            LinkFollowSpecs linkFollowSpecs = this.getLinkFollowSpecs().follow("members[" + action.getId() + "]", new Object[0]);
            ObjectActionReprRenderer renderer = new ObjectActionReprRenderer(this.getRendererContext(), linkFollowSpecs, action.getId(), JsonRepresentation.newMap((String[])new String[0]));
            ((ObjectActionReprRenderer)renderer.with(new ObjectAndAction(objectAdapter, action))).usingLinkTo(this.linkToBuilder);
            members.mapPut(action.getId(), renderer.render());
        }
    }

    private void addPersistLinkIfTransientAndPersistable() {
        if (this.objectAdapter.representsPersistent()) {
            return;
        }
        if (this.objectAdapter.getSpecification().containsDoOpFacet(NotPersistableFacet.class)) {
            return;
        }
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getRendererContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        JsonRepresentation domainObjectRepr = renderer.with(this.objectAdapter).asPersistLinkArguments().render();
        String domainType = this.objectAdapter.getSpecification().getSpecId().asString();
        LinkBuilder persistLinkBuilder = LinkBuilder.newBuilder(this.getRendererContext(), Rel.PERSIST.getName(), RepresentationType.DOMAIN_OBJECT, "objects/%s", domainType).withHttpMethod(RestfulHttpMethod.POST).withArguments(domainObjectRepr);
        this.getLinks().arrayAdd(persistLinkBuilder.build());
    }

    private DomainObjectReprRenderer asPersistLinkArguments() {
        this.mode = Mode.PERSIST_LINK_ARGUMENTS;
        return this;
    }

    private DomainObjectReprRenderer asUpdatePropertiesLinkArguments() {
        this.mode = Mode.UPDATE_PROPERTIES_LINK_ARGUMENTS;
        return this;
    }

    public DomainObjectReprRenderer asEventSerialization() {
        this.mode = Mode.EVENT_SERIALIZATION;
        return this;
    }

    private void addUpdatePropertiesLinkIfRequired() {
        if (this.mode.isEventSerialization()) {
            return;
        }
        if (!this.objectAdapter.representsPersistent()) {
            return;
        }
        boolean isService = this.objectAdapter.getSpecification().isService();
        if (isService) {
            return;
        }
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(this.getRendererContext(), null, JsonRepresentation.newMap((String[])new String[0]));
        JsonRepresentation domainObjectRepr = renderer.with(this.objectAdapter).asUpdatePropertiesLinkArguments().render();
        if (!this.getRendererContext().suppressUpdateLink()) {
            LinkBuilder updateLinkBuilder = LinkBuilder.newBuilder(this.getRendererContext(), Rel.UPDATE.getName(), RepresentationType.DOMAIN_OBJECT, "objects/%s/%s", this.getDomainType(), this.getInstanceId()).withHttpMethod(RestfulHttpMethod.PUT).withArguments(domainObjectRepr);
            this.getLinks().arrayAdd(updateLinkBuilder.build());
        }
    }

    public static Object valueOrRef(RendererContext resourceContext, ObjectAdapter objectAdapter, ObjectSpecification objectSpec) {
        if (objectAdapter.isValue()) {
            String format = null;
            return JsonValueEncoder.asObject(objectAdapter, format);
        }
        TitleFacet titleFacet = (TitleFacet)objectSpec.getFacet(TitleFacet.class);
        String title = titleFacet.title(objectAdapter);
        return DomainObjectReprRenderer.newLinkToBuilder(resourceContext, Rel.VALUE, objectAdapter).withTitle(title).build();
    }

    private static enum Mode {
        REGULAR,
        PERSIST_LINK_ARGUMENTS,
        UPDATE_PROPERTIES_LINK_ARGUMENTS,
        EVENT_SERIALIZATION;


        public boolean isRegular() {
            return this == REGULAR;
        }

        public boolean isPersistLinkArgs() {
            return this == PERSIST_LINK_ARGUMENTS;
        }

        public boolean isUpdatePropertiesLinkArgs() {
            return this == UPDATE_PROPERTIES_LINK_ARGUMENTS;
        }

        public boolean isEventSerialization() {
            return this == EVENT_SERIALIZATION;
        }

        public boolean includeDescribedBy() {
            return this.isRegular() || this.isPersistLinkArgs();
        }

        public boolean includeUp() {
            return this.isRegular();
        }

        public boolean checkVisibility() {
            return this.isRegular() || this.isUpdatePropertiesLinkArgs();
        }

        public boolean isArgs() {
            return this.isPersistLinkArgs() || this.isUpdatePropertiesLinkArgs();
        }
    }
}

