/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Collection;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.RestfulHttpMethod;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.InvokeKeys;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ListReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndActionInvocation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ScalarValueReprRenderer;

public class ActionResultReprRenderer
extends ReprRendererAbstract<ActionResultReprRenderer, ObjectAndActionInvocation> {
    private ObjectAdapterLinkTo adapterLinkTo = new DomainObjectLinkTo();
    private ObjectAdapter objectAdapter;
    private ObjectAction action;
    private JsonRepresentation arguments;
    private ObjectAdapter returnedAdapter;
    private final SelfLink selfLink;
    private ObjectAndActionInvocation objectAndActionInvocation;

    public ActionResultReprRenderer(RendererContext rendererContext, LinkFollowSpecs linkFollower, SelfLink selfLink, JsonRepresentation representation) {
        super(rendererContext, linkFollower, RepresentationType.ACTION_RESULT, representation);
        this.selfLink = selfLink;
    }

    @Override
    public ActionResultReprRenderer with(ObjectAndActionInvocation objectAndActionInvocation) {
        this.objectAndActionInvocation = objectAndActionInvocation;
        this.objectAdapter = objectAndActionInvocation.getObjectAdapter();
        this.action = objectAndActionInvocation.getAction();
        this.arguments = objectAndActionInvocation.getArguments();
        this.returnedAdapter = objectAndActionInvocation.getReturnedAdapter();
        this.adapterLinkTo.with(this.returnedAdapter);
        return this;
    }

    public void using(ObjectAdapterLinkTo adapterLinkTo) {
        this.adapterLinkTo = adapterLinkTo.with(this.objectAdapter);
    }

    @Override
    public JsonRepresentation render() {
        if (this.representation == null) {
            return null;
        }
        this.representationWithSelfFor(this.action, this.arguments);
        this.addResult(this.representation);
        this.addExtensionsIsisProprietaryChangedObjects();
        return this.representation;
    }

    private void addResult(JsonRepresentation representation) {
        ActionResultRepresentation.ResultType resultType = this.objectAndActionInvocation.determineResultType();
        JsonRepresentation result = JsonRepresentation.newMap((String[])new String[0]);
        this.addResultTo(resultType, result);
        this.putResultType(representation, resultType);
        if (!resultType.isVoid()) {
            if (this.returnedAdapter != null) {
                representation.mapPut("result", result);
            } else {
                representation.mapPut("result", (JsonNode)NullNode.getInstance());
            }
        }
    }

    private void addResultTo(ActionResultRepresentation.ResultType resultType, JsonRepresentation representation) {
        if (this.returnedAdapter == null) {
            return;
        }
        ReprRendererAbstract<?, ?> renderer = this.buildResultRenderer(resultType, representation);
        if (renderer != null) {
            renderer.render();
        }
    }

    private ReprRendererAbstract<?, ?> buildResultRenderer(ActionResultRepresentation.ResultType resultType, JsonRepresentation representation) {
        ObjectSpecification returnType = this.action.getReturnType();
        switch (resultType) {
            case VOID: {
                return null;
            }
            case LIST: {
                CollectionFacet collectionFacet = (CollectionFacet)returnType.getFacet(CollectionFacet.class);
                Collection collectionAdapters = collectionFacet.collection(this.returnedAdapter);
                ListReprRenderer listReprRenderer = new ListReprRenderer(this.rendererContext, null, representation).withElementRel(Rel.ELEMENT);
                listReprRenderer.with(collectionAdapters).withReturnType(this.action.getReturnType()).withElementType(this.returnedAdapter.getElementSpecification());
                return listReprRenderer;
            }
            case SCALAR_VALUE: {
                ScalarValueReprRenderer scalarValueReprRenderer = new ScalarValueReprRenderer(this.rendererContext, null, representation);
                scalarValueReprRenderer.with(this.returnedAdapter).withReturnType(this.action.getReturnType());
                return scalarValueReprRenderer;
            }
            case DOMAIN_OBJECT: {
                DomainObjectReprRenderer objectReprRenderer = new DomainObjectReprRenderer(this.rendererContext, null, representation);
                objectReprRenderer.with(this.returnedAdapter).includesSelf();
                return objectReprRenderer;
            }
        }
        throw new IllegalStateException("All possible states of ResultType enumerated; resultType = " + resultType);
    }

    private void putResultType(JsonRepresentation representation, ActionResultRepresentation.ResultType resultType) {
        representation.mapPut("resulttype", resultType.getValue());
    }

    private void representationWithSelfFor(ObjectAction action, JsonRepresentation bodyArgs) {
        JsonRepresentation links = JsonRepresentation.newArray();
        this.representation.mapPut("links", links);
        if (this.selfLink == SelfLink.EXCLUDED) {
            return;
        }
        LinkBuilder selfLinkBuilder = this.adapterLinkTo.memberBuilder(Rel.SELF, MemberType.ACTION, (ObjectMember)action, RepresentationType.ACTION_RESULT, "invoke");
        MemberType memberType = MemberType.of((ObjectMember)action);
        Map<String, MutatorSpec> mutators = memberType.getMutators();
        String mutator = InvokeKeys.getKeyFor(action.getSemantics());
        MutatorSpec mutatorSpec = mutators.get(mutator);
        selfLinkBuilder.withHttpMethod(mutatorSpec.httpMethod);
        JsonRepresentation selfLink = selfLinkBuilder.build();
        links.arrayAdd(selfLink);
        selfLink.mapPut("args", bodyArgs);
        LinkBuilder upLinkBuilder = this.adapterLinkTo.memberBuilder(Rel.UP, MemberType.ACTION, (ObjectMember)action, RepresentationType.OBJECT_ACTION, new String[0]);
        upLinkBuilder.withHttpMethod(RestfulHttpMethod.GET);
        links.arrayAdd(upLinkBuilder.build());
    }

    public static enum SelfLink {
        INCLUDED,
        EXCLUDED;

    }
}

