/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;

public class IsisTransactionFilterForRestfulObjects
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        IsisSessionFactory isisSessionFactory = this.isisSessionFactoryFrom(request);
        if (!isisSessionFactory.inSession()) {
            chain.doFilter(request, response);
            return;
        }
        IsisTransactionManager isisTransactionManager = this.transactionManagerFrom(isisSessionFactory);
        isisTransactionManager.startTransaction();
        try {
            chain.doFilter(request, response);
        }
        finally {
            boolean inTransaction = isisSessionFactory.inTransaction();
            if (inTransaction) {
                try {
                    isisTransactionManager.endTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void destroy() {
    }

    protected IsisSessionFactory isisSessionFactoryFrom(ServletRequest request) {
        return IsisContext.getSessionFactory();
    }

    protected IsisTransactionManager transactionManagerFrom(IsisSessionFactory isisSessionFactory) {
        return isisSessionFactory.getCurrentSession().getPersistenceSession().getTransactionManager();
    }
}

