/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.server.util;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.server.util.UrlDecoderUtils;

public final class OidUtils {
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;

    private OidUtils() {
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String domainType, String instanceIdEncoded) {
        String instanceIdUnencoded = UrlDecoderUtils.urlDecode(instanceIdEncoded);
        String oidStrUnencoded = OID_MARSHALLER.joinAsOid(domainType, instanceIdUnencoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    public static ObjectAdapter getObjectAdapterElseNull(RendererContext rendererContext, String oidStrEncoded) {
        String oidStrUnencoded = UrlDecoderUtils.urlDecode(oidStrEncoded);
        return OidUtils.getObjectAdapter(rendererContext, oidStrUnencoded);
    }

    private static ObjectAdapter getObjectAdapter(RendererContext rendererContext, String oidStrUnencoded) {
        RootOid rootOid = RootOid.deString((String)oidStrUnencoded);
        PersistenceSession persistenceSession = rendererContext.getPersistenceSession();
        return persistenceSession.adapterForAny(rootOid);
    }
}

